/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.sourcecode.coverage.CoverageUnitContainer;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestInfoContainer;
import org.conqat.lib.commons.collections.CaseInsensitiveMap;

public class CoverageInfoRetriever {
    private final Map<String, LineCoverageInfo> lineCoverage;
    private final Map<String, ProbeCoverageInfo> probeCoverage;
    private final Map<String, TestInfoContainer> testwiseCoverage;
    private final Map<String, ExecutionUnit> executableUnits;
    private final Map<String, CoverageUnitContainer> coverageUnits;

    public CoverageInfoRetriever() {
        this(false);
    }

    public CoverageInfoRetriever(boolean caseSensitive) {
        if (caseSensitive) {
            this.lineCoverage = new HashMap<String, LineCoverageInfo>();
            this.probeCoverage = new HashMap<String, ProbeCoverageInfo>();
        } else {
            this.lineCoverage = new CaseInsensitiveMap();
            this.probeCoverage = new CaseInsensitiveMap();
        }
        this.testwiseCoverage = new HashMap<String, TestInfoContainer>();
        this.executableUnits = new HashMap<String, ExecutionUnit>();
        this.coverageUnits = new HashMap<String, CoverageUnitContainer>();
    }

    public LineCoverageInfo getOrCreateLineCoverageInfo(String qualifiedSourceName) {
        return this.lineCoverage.computeIfAbsent(qualifiedSourceName, k -> new LineCoverageInfo(false));
    }

    public ProbeCoverageInfo getOrCreateProbeCoverageInfo(String qualifiedSourceName) {
        return this.probeCoverage.computeIfAbsent(qualifiedSourceName, k -> new ProbeCoverageInfo(true));
    }

    public TestInfoContainer createTestwiseCoverageInfo(String testExecutionPath) {
        return this.testwiseCoverage.computeIfAbsent(testExecutionPath, TestInfoContainer::new);
    }

    public ExecutionUnit createExecutionUnit(String executionUnitUniformPath) {
        return this.executableUnits.computeIfAbsent(executionUnitUniformPath, ExecutionUnit::new);
    }

    public CoverageUnitContainer createCoverageUnitContainer(String coverageUnitPath) {
        return this.coverageUnits.computeIfAbsent(coverageUnitPath, k -> new CoverageUnitContainer());
    }

    public Set<String> getAllPaths() {
        HashSet<String> reportPaths = new HashSet<String>();
        reportPaths.addAll(this.lineCoverage.keySet());
        reportPaths.addAll(this.probeCoverage.keySet());
        reportPaths.addAll(this.coverageUnits.values().stream().flatMap(v -> v.getCoverageInfo().getCoverage().keySet().stream()).collect(Collectors.toSet()));
        return reportPaths;
    }

    public Map<String, LineCoverageInfo> getAllLineCoverage() {
        return this.lineCoverage;
    }

    public Map<String, ProbeCoverageInfo> getAllProbeCoverage() {
        return this.probeCoverage;
    }

    public Map<String, TestInfoContainer> getAllTestwiseCoverage() {
        return this.testwiseCoverage;
    }

    public Map<String, ExecutionUnit> getAllExecutionUnits() {
        return this.executableUnits;
    }

    public Map<String, CoverageUnitContainer> getAllCoverageUnits() {
        return this.coverageUnits;
    }
}

