/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.utils.StringPool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class MultiFileRangeCoverageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uniformPathToRanges")
    private Map<String, CompactLines> uniformPathToRanges;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="coverableLines")
    private final Map<String, CompactLines> uniformPathToCoverableLineRanges;

    @JsonCreator
    public MultiFileRangeCoverageInfo() {
        this(-1L);
    }

    public MultiFileRangeCoverageInfo(long timestamp) {
        this.timestamp = timestamp;
        this.uniformPathToRanges = new HashMap<String, CompactLines>();
        this.uniformPathToCoverableLineRanges = new HashMap<String, CompactLines>();
    }

    public void addLineCoverage(MultiFileRangeCoverageInfo newCoverage) {
        Set<Map.Entry<String, CompactLines>> newTestCoverage = newCoverage.uniformPathToRanges.entrySet();
        for (Map.Entry<String, CompactLines> testCoverage : newTestCoverage) {
            this.uniformPathToRanges.put(testCoverage.getKey(), testCoverage.getValue());
        }
    }

    public void addLineCoverage(String uniformPath, CompactLines lines) {
        this.uniformPathToRanges.computeIfAbsent(uniformPath, k -> new CompactLines()).addAll(lines);
    }

    public void addCoverableLines(String uniformPath, CompactLines lines) {
        this.uniformPathToCoverableLineRanges.computeIfAbsent(uniformPath, k -> new CompactLines()).addAll(lines);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Map<String, CompactLines> getCoverage() {
        return this.uniformPathToRanges;
    }

    public Map<String, CompactLines> getCoverableLines() {
        if (this.uniformPathToCoverableLineRanges == null) {
            return new HashMap<String, CompactLines>();
        }
        return this.uniformPathToCoverableLineRanges;
    }

    public String toString() {
        return "Covered: " + this.uniformPathToRanges.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(pair -> (String)pair.getKey() + " " + String.valueOf(pair.getValue())).collect(Collectors.joining(", ")) + "; timestamp: " + this.timestamp;
    }

    public void changeFilePath(String reportPath, String pathInTeamscale) {
        if (this.uniformPathToRanges.containsKey(reportPath) && !reportPath.equals(pathInTeamscale)) {
            CompactLines ranges = this.uniformPathToRanges.remove(reportPath);
            this.uniformPathToRanges.put(pathInTeamscale, ranges);
        }
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.timestamp = inputStream.readLong();
        this.uniformPathToRanges = new HashMap<String, CompactLines>();
        int entries = inputStream.readInt();
        for (int i = 0; i < entries; ++i) {
            String path = StringPool.intern(inputStream.readUTF());
            CompactLines list = (CompactLines)inputStream.readObject();
            this.uniformPathToRanges.put(path, list);
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeLong(this.timestamp);
        outputStream.writeInt(this.uniformPathToRanges.size());
        for (Map.Entry<String, CompactLines> entry : this.uniformPathToRanges.entrySet()) {
            outputStream.writeUTF(entry.getKey());
            outputStream.writeObject(entry.getValue());
        }
    }

    public long getEstimatedSizeBytes() {
        return this.uniformPathToRanges.entrySet().stream().mapToLong(entry -> (long)((String)entry.getKey()).length() + (long)((CompactLines)entry.getValue()).size() * 4L).sum();
    }
}

