/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TestUniformPathUtils {
    public static final String TEST_PARAMETERIZATION_START = "[";
    public static final String TEST_PARAMETERIZATION_END = "]";
    public static final String TEST_SIGNATURE_START = "(";

    public static void assertIsTestExecutionPath(String uniformPath) {
        Preconditions.checkArgument((uniformPath != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)uniformPath.startsWith(UniformPath.EType.TEST_EXECUTION.getPrefix() + UniformPathUtils.SEPARATOR), (Object)("Test execution path " + uniformPath + " was expected to start with -test-execution-!"));
    }

    public static void assertIsCoverageUnitPath(String uniformPath) {
        Preconditions.checkArgument((uniformPath != null ? 1 : 0) != 0);
        Preconditions.checkArgument((uniformPath.startsWith(UniformPath.EType.TEST_EXECUTION.getPrefix() + UniformPathUtils.SEPARATOR) || uniformPath.startsWith(UniformPath.EType.EXECUTION_UNIT.getPrefix() + UniformPathUtils.SEPARATOR) ? 1 : 0) != 0, (Object)("Coverage unit path " + uniformPath + " was expected to start with -test-execution- or -execution-unit-!"));
    }

    public static UniformPath escapeAndConvertToTestExecutionUniformPath(String testUniformPath) {
        Preconditions.checkArgument((!testUniformPath.startsWith(UniformPath.EType.TEST_EXECUTION.getPrefix()) ? 1 : 0) != 0);
        testUniformPath = StringUtils.stripPrefix((String)testUniformPath, (String)UniformPathUtils.SEPARATOR);
        List<String> testPathSegments = TestUniformPathUtils.getTestPathSegments(testUniformPath);
        return UniformPath.ofSegments(UniformPath.EType.TEST_EXECUTION, testPathSegments);
    }

    public static UniformPath convertToExecutionUnitUniformPath(String executableUnitPath) {
        Preconditions.checkArgument((!executableUnitPath.startsWith(UniformPath.EType.EXECUTION_UNIT.getPrefix()) ? 1 : 0) != 0);
        RelativeUniformPath relativeUniformPath = UniformPathCompatibilityUtil.convertRelative(executableUnitPath);
        return UniformPath.ofSegments(UniformPath.EType.EXECUTION_UNIT, new String[0]).resolve(relativeUniformPath);
    }

    private static List<String> getTestPathSegments(String testUniformPath) {
        List<String> segments = Arrays.asList(UniformPathUtils.splitPath(testUniformPath));
        for (int i = 0; i < segments.size(); ++i) {
            if (!segments.get(i).contains(TEST_PARAMETERIZATION_START) && !segments.get(i).contains(TEST_SIGNATURE_START) && i != segments.size() - 1) continue;
            String testName = StringUtils.concat(segments.subList(i, segments.size()), (String)UniformPathUtils.SEPARATOR);
            ArrayList<String> testSegments = new ArrayList<String>(segments.subList(0, i));
            testSegments.add(UniformPath.escapeSegment(testName));
            return testSegments;
        }
        return Collections.singletonList(UniformPath.escapeSegment(testUniformPath));
    }

    public static String convertCoverageUnitPathToTestName(String uniformPath) {
        TestUniformPathUtils.assertIsCoverageUnitPath(uniformPath);
        String testIdWithoutPrefix = StringUtils.stripPrefix((String)uniformPath, (String)(UniformPath.EType.TEST_EXECUTION.getPrefix() + UniformPathUtils.SEPARATOR));
        testIdWithoutPrefix = StringUtils.stripPrefix((String)testIdWithoutPrefix, (String)(UniformPath.EType.EXECUTION_UNIT.getPrefix() + UniformPathUtils.SEPARATOR));
        return UniformPath.unescapeSegment(testIdWithoutPrefix);
    }

    private TestUniformPathUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

