/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.CodeUniformPath;
import org.conqat.lib.commons.uniformpath.IVirtualCodeUniformPath;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Serialized externally by super-class")
public final class CodeScopeUniformPath
extends UniformPath
implements IVirtualCodeUniformPath {
    public static final CodeScopeUniformPath ROOT = new CodeScopeUniformPath((UnmodifiableList<String>)CollectionUtils.emptyList());

    private CodeScopeUniformPath(UnmodifiableList<String> segments) {
        super(UniformPath.EType.CODE_SCOPES, segments);
    }

    public static CodeScopeUniformPath ofSegments(String ... segments) {
        return CodeScopeUniformPath.ofSegments(Arrays.asList(segments));
    }

    public static CodeScopeUniformPath ofSegments(List<String> segments) {
        return (CodeScopeUniformPath)UniformPath.EType.CODE_SCOPES.with(segments);
    }

    public static CodeScopeUniformPath parse(String path) {
        return (CodeScopeUniformPath)UniformPath.parse(UniformPath.EType.CODE_SCOPES, path);
    }

    static CodeScopeUniformPath of(UnmodifiableList<String> segments) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        return new CodeScopeUniformPath(segments);
    }

    @Override
    public UniformPath resolveToCodePath() {
        if (this.segments.size() <= 1) {
            return CodeUniformPath.ROOT;
        }
        return CodeUniformPath.of((UnmodifiableList<String>)this.segments.subList(1, this.segments.size()));
    }

    @Override
    public Optional<CodeScopeName> getCodeScope() {
        if (this.isRoot()) {
            return Optional.empty();
        }
        return Optional.of(new CodeScopeName((String)this.segments.getFirst()));
    }

    @Override
    public CodeScopeUniformPath resolve(RelativeUniformPath relativeUniformPath) {
        return (CodeScopeUniformPath)this.doResolve(relativeUniformPath);
    }
}

