/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.CodeScopeUniformPath;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Serialized externally by super-class")
public final class CodeUniformPath
extends UniformPath {
    public static final CodeUniformPath ROOT = new CodeUniformPath((UnmodifiableList<String>)CollectionUtils.emptyList());

    private CodeUniformPath(UnmodifiableList<String> segments) {
        super(UniformPath.EType.CODE, segments);
    }

    public static CodeUniformPath ofSegments(String ... segments) {
        return CodeUniformPath.ofSegments(Arrays.asList(segments));
    }

    public static CodeUniformPath ofSegments(List<String> segments) {
        return (CodeUniformPath)UniformPath.EType.CODE.with(segments);
    }

    public static CodeUniformPath parse(String path) {
        return (CodeUniformPath)UniformPath.parse(UniformPath.EType.CODE, path);
    }

    static CodeUniformPath of(UnmodifiableList<String> segments) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        return new CodeUniformPath(segments);
    }

    @Override
    public CodeScopeUniformPath asCodeScopePath(CodeScopeName codeScopeName) {
        ArrayList<String> newSegments = new ArrayList<String>(this.segments.size() + 1);
        newSegments.add(codeScopeName.name());
        newSegments.addAll((Collection<String>)this.segments);
        return CodeScopeUniformPath.of((UnmodifiableList<String>)UnmodifiableList.of(newSegments));
    }

    @Override
    public CodeUniformPath resolve(RelativeUniformPath relativeUniformPath) {
        return (CodeUniformPath)this.doResolve(relativeUniformPath);
    }

    @Override
    protected String computeToString() {
        return this.getPathSegmentsString();
    }
}

