/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.IWorkItemUniformPath;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Serialized externally by super-class")
public final class IssueItemUniformPath
extends UniformPath
implements IWorkItemUniformPath {
    public static final IssueItemUniformPath ROOT = new IssueItemUniformPath((UnmodifiableList<String>)CollectionUtils.emptyList());

    private IssueItemUniformPath(UnmodifiableList<String> segments) {
        super(UniformPath.EType.ISSUE_ITEM, segments);
    }

    public static IssueItemUniformPath ofSegments(String ... segments) {
        return IssueItemUniformPath.ofSegments(Arrays.asList(segments));
    }

    public static IssueItemUniformPath ofSegments(List<String> segments) {
        return (IssueItemUniformPath)UniformPath.EType.ISSUE_ITEM.with(segments);
    }

    public static IssueItemUniformPath parse(String path) {
        return (IssueItemUniformPath)UniformPath.parse(UniformPath.EType.ISSUE_ITEM, path);
    }

    static IssueItemUniformPath of(UnmodifiableList<String> segments) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        if (segments.size() > 2) {
            throw new IllegalArgumentException("Issue item paths can only have two segments at most, but got: " + String.valueOf(segments));
        }
        return new IssueItemUniformPath(segments);
    }

    @Override
    public IssueItemUniformPath resolve(RelativeUniformPath relativeUniformPath) {
        return (IssueItemUniformPath)this.doResolve(relativeUniformPath);
    }
}

