/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.IQueryUniformPath;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Serialized externally by super-class")
public final class IssueQueryUniformPath
extends UniformPath
implements IQueryUniformPath {
    public static final IssueQueryUniformPath ROOT = new IssueQueryUniformPath((UnmodifiableList<String>)CollectionUtils.emptyList());

    private IssueQueryUniformPath(UnmodifiableList<String> segments) {
        super(UniformPath.EType.ISSUE_QUERY, segments);
    }

    public static IssueQueryUniformPath ofSegments(String ... segments) {
        return IssueQueryUniformPath.ofSegments(Arrays.asList(segments));
    }

    public static IssueQueryUniformPath ofSegments(List<String> segments) {
        return (IssueQueryUniformPath)UniformPath.EType.ISSUE_QUERY.with(segments);
    }

    public static IssueQueryUniformPath parse(String path) {
        return (IssueQueryUniformPath)UniformPath.parse(UniformPath.EType.ISSUE_QUERY, path);
    }

    static IssueQueryUniformPath of(UnmodifiableList<String> segments) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        return new IssueQueryUniformPath(segments);
    }

    @Override
    public Optional<String> getQueryName() {
        if (this.segments.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)this.segments));
    }

    @Override
    public IssueQueryUniformPath resolve(RelativeUniformPath relativeUniformPath) {
        return (IssueQueryUniformPath)this.doResolve(relativeUniformPath);
    }
}

