/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.uniformpath;

import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;

@NoIndexValueClass(rationale="Serialized externally by super-class")
public final class NonCodeUniformPath
extends UniformPath {
    public static final NonCodeUniformPath ROOT = new NonCodeUniformPath((UnmodifiableList<String>)CollectionUtils.emptyList());

    private NonCodeUniformPath(UnmodifiableList<String> segments) {
        super(UniformPath.EType.NON_CODE, segments);
    }

    public static NonCodeUniformPath ofSegments(String ... segments) {
        return NonCodeUniformPath.ofSegments(Arrays.asList(segments));
    }

    public static NonCodeUniformPath ofSegments(List<String> segments) {
        return (NonCodeUniformPath)UniformPath.EType.NON_CODE.with(segments);
    }

    public static NonCodeUniformPath parse(String path) {
        return (NonCodeUniformPath)UniformPath.parse(UniformPath.EType.NON_CODE, path);
    }

    static NonCodeUniformPath of(UnmodifiableList<String> segments) {
        if (segments.isEmpty()) {
            return ROOT;
        }
        return new NonCodeUniformPath(segments);
    }

    @Override
    public NonCodeUniformPath resolve(RelativeUniformPath relativeUniformPath) {
        return (NonCodeUniformPath)this.doResolve(relativeUniformPath);
    }
}

