import{_ as t,c as i,ak as s,o as a}from"./chunks/framework.CM689eR4.js";const f=JSON.parse('{"title":"Connecting to Servers Via HTTPS","description":"This guide shows you how to connect Teamscale to external servers like issue trackers accessible over TLS and HTTPS.","frontmatter":{"title":"Connecting to Servers Via HTTPS","description":"This guide shows you how to connect Teamscale to external servers like issue trackers accessible over TLS and HTTPS."},"headers":[],"relativePath":"howto/connecting-via-https/index.md","filePath":"howto/connecting-via-https/index.md"}'),o={name:"howto/connecting-via-https/index.md"};function r(n,e,c,l,h,d){return a(),i("div",null,[...e[0]||(e[0]=[s(`<h1 id="how-to-connect-to-external-servers-via-https" tabindex="-1">How to Connect to External Servers Via HTTPS <a class="header-anchor" href="#how-to-connect-to-external-servers-via-https" aria-label="Permalink to &quot;How to Connect to External Servers Via HTTPS&quot;">​</a></h1><p>Under normal circumstances, connecting to external systems (source code repositories, issue trackers, etc.) via HTTPS does not require any configuration; Teamscale will use the default Java certificate store and, if it contains a valid certificate chain to validate the external system&#39;s SSL/TLS certificate, everything will work out of the box. There are circumstances, however, where you need to perform some explicit configuration.</p><nav class="table-of-contents"><ul><li><a href="#using-self-signed-certificates">Using Self-Signed Certificates</a></li><li><a href="#using-certificates-from-the-windows-certificate-store">Using Certificates from the Windows Certificate Store</a></li><li><a href="#turning-off-certificate-validation">Turning Off Certificate Validation</a></li></ul></nav><h2 id="using-self-signed-certificates" tabindex="-1">Using Self-Signed Certificates <a class="header-anchor" href="#using-self-signed-certificates" aria-label="Permalink to &quot;Using Self-Signed Certificates&quot;">​</a></h2><p>If the external system is accessed via HTTPS but the certificate for the underlying SSL/TLS connections is not signed by one of the certificate authorities known to a default Java installation, Teamscale needs to be made aware of the certificate. Start by downloading the certificate in question, e.g., through your web browser, and store it in DER format (<code>.cer</code> file extension).</p><div class="tip custom-block"><p class="custom-block-title">Using Self-Signed Certificates with Cloud Instances</p><p>To use a self-signed certificate with your cloud instance, just email it to our support team at <a href="mailto:support@teamscale.com" target="_blank" rel="noreferrer">support@teamscale.com</a>. We&#39;ll take care of everything else.</p></div><p>Next, create a trust store that contains that certificate. The trust store is a Java Keystore (.jks) created with the <code>keytool</code> command line tool (located in <code>$JAVA_HOME/bin/keytool</code>). We use the name &quot;trust store&quot; to emphasize that it contains the certificates of other server that Teamscale should trust. In contrast to the trust store, the <em>keystore</em> contains Teamscale&#39;s own certificate that is used if Teamscale itself offers HTTPS (<a href="./../configuring-https/">Accessing Teamscale via HTTPS</a>).</p><p>To create the trust store use the <code>keytool</code> as follows: (<code>certificate.cer</code> is the certificate you downloaded, <code>truststore.jks</code> is the trust store to be created and <code>Alias</code> is the alias under which to store the certificate in the trust store.)</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">keytool</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -importcert</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -file</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> certificate.cer</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -keystore</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> truststore.jks</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -alias</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> Alias</span></span></code></pre></div><p>You will be prompted for a password for the trust store. Multiple certificates can be imported into the same trust store under different aliases.</p><p>After all necessary certificates have been imported, add the following to the <code>JVM_EXTRA_ARGS</code> entry in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code>:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Djavax.net.ssl.trustStore</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;Path-to-Truststore-File&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Djavax.net.ssl.trustStorePassword</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=&lt;Password&gt;</span></span></code></pre></div><p>Note that this trust store will only contain the certificate(s) manually imported earlier. In case you <em>also</em> depend on the default certificates present on the system, you can import these into your trust store from the default installation (usually <code>$JAVA_HOME/jre/lib/security/cacerts</code>) using the <code>-importkeystore</code> command.</p><h2 id="using-certificates-from-the-windows-certificate-store" tabindex="-1">Using Certificates from the Windows Certificate Store <a class="header-anchor" href="#using-certificates-from-the-windows-certificate-store" aria-label="Permalink to &quot;Using Certificates from the Windows Certificate Store&quot;">​</a></h2><p>On Windows, you can use the certificates from the operating system&#39;s build-in certificate store. by adding the following options to the entry <code>JVM_EXTRA_ARGS</code> in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code>:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Djavax.net.ssl.trustStoreType</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=Windows-ROOT</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Djavax.net.ssl.trustStore</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=NUL</span></span></code></pre></div><h2 id="turning-off-certificate-validation" tabindex="-1">Turning Off Certificate Validation <a class="header-anchor" href="#turning-off-certificate-validation" aria-label="Permalink to &quot;Turning Off Certificate Validation&quot;">​</a></h2><p>In case the certificates are not valid (e.g., the hostname is incorrect), Java will still reject the certificates and refuse HTTPS connections to the external systems. To fix this problem, you can either install a valid certificate on the server or instruct Teamscale to not validate any SSL/TLS certificates.</p><p>To disable validation of SSL certificates, add the following to the entry <code>JVM_EXTRA_ARGS</code> in the file <code>$TEAMSCALE_HOME/config/jvm.properties</code>:</p><div class="language-properties vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">properties</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">-</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">Dcom.teamscale.disable-ssl-certificate-validation</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=true</span></span></code></pre></div><div class="danger custom-block"><p class="custom-block-title">Not Secure</p><p>Disabling SSL validation is <strong>strongly discouraged</strong>; it is not a secure practice.</p></div>`,21)])])}const u=t(o,[["render",r]]);export{f as __pageData,u as default};
