import{_ as i,c as t,ak as a,o as n}from"./chunks/framework.CM689eR4.js";const s="/assets/critical_change_badge_configuration.DsrgvsAC.png",r="/assets/configured_critical_change_badges.BkOD9cZN.png",o="/assets/bitbucket_pull_request_with_critical_change_badges.Bvsargq7.png",c="/assets/critical_changes_section.C1XXCJpF.png",b=JSON.parse('{"title":"Tracking Metrics in Merge Requests","description":"","frontmatter":{"title":"Tracking Metrics in Merge Requests"},"headers":[],"relativePath":"howto/tracking-critical-changes-in-merge-requests/index.md","filePath":"howto/tracking-critical-changes-in-merge-requests/index.md"}'),l={name:"howto/tracking-critical-changes-in-merge-requests/index.md"};function g(h,e,d,p,u,m){return n(),t("div",null,[...e[0]||(e[0]=[a('<h1 id="tracking-of-critical-changes-in-merge-requests" tabindex="-1">Tracking of Critical Changes in Merge Requests <a class="header-anchor" href="#tracking-of-critical-changes-in-merge-requests" aria-label="Permalink to &quot;Tracking of Critical Changes in Merge Requests&quot;">​</a></h1><p>This guide provides a detailed approach to tracking critical changes that require special attention within your codebase through merge requests. Teamscale automatically generates and adds critical change badges to merge requests in your code collaboration platform, while also displaying an in-depth overview of these critical changes in the Teamscale merge request details view. By configuring regex patterns, you can identify critical paths or methods, ensuring that crucial changes receive the necessary attention during the review process.</p><h2 id="connector-configuration" tabindex="-1">Connector Configuration <a class="header-anchor" href="#connector-configuration" aria-label="Permalink to &quot;Connector Configuration&quot;">​</a></h2><p>If Teamscale supports this feature for your code collaboration platform, the respective connector will offer an option to add <em>Badges for Critical Changes</em>.</p><ol><li>In the connector configuration, click on <code>Advanced Settings</code>.</li><li>In the <code>Badges for Critical Changes</code> option, click the <code>Add new badge</code> button to open a dialog for configuring a critical change badge.</li><li>Configure each badge with the following: <ul><li><em>Badge Title</em>: The text to be displayed on the left side of the badge.</li><li><em>Badge Text</em>: The text to be displayed on the right side of the badge.</li><li><em>Badge Description</em>: Markdown-supported text explaining the purpose of this badge. This text will be displayed in the merge request detail view.</li><li><em>Critical Change Patterns</em>: The regex patterns defining critical changes that should trigger posting of the badge. Details on the regex pattern format are described <a href="#critical-change-pattern-format">below</a>.</li><li><em>Badge Color</em>: Background color of the badge.</li><li><em>Badge Hover Text (optional)</em>: Tooltip text shown when hovering over the badge.</li><li><em>Badge Link (optional)</em>: URL to be opened when clicking on the badge. If left empty, clicking on the badge will navigate to the merge request detail view. <img src="'+s+'" alt="Configuration of a critical change badge" width="1072" height="1434" data-zoom="true"></li></ul></li><li>Click <code>OK</code> to save your input.</li><li>Save the project configuration after configuring all the critical change badges you want. <img src="'+r+'" alt="Connector configuration with multiple configured critical change badges" width="1688" height="542" data-zoom="true"></li></ol><div class="tip custom-block"><p class="custom-block-title">Updates in Merge Requests</p><p>Changes in this configuration are only updated in merge requests on the next vote. This includes adding, editing, or removing any badges from the configuration.</p></div><h2 id="critical-change-pattern-format" tabindex="-1">Critical Change Pattern Format <a class="header-anchor" href="#critical-change-pattern-format" aria-label="Permalink to &quot;Critical Change Pattern Format&quot;">​</a></h2><p>You can define two types of patterns:</p><ol><li><strong>File-only Patterns</strong>: Match files by their path. For example:</li></ol><div class="language-regexp vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">regexp</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#DBEDFF;">src/main/java/com/example/security/</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">.</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">*</span></span></code></pre></div><p>This pattern matches any file in the security package.</p><ol start="2"><li><strong>Method Patterns</strong>: Match specific methods within specific files using a <code>#</code> separator. For example:</li></ol><div class="language-regexp vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">regexp</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#032F62;--shiki-dark:#DBEDFF;">src/main/java/com/example/security/</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">.</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">*</span><span style="--shiki-light:#032F62;--shiki-dark:#DBEDFF;">#authenticate</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">.</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">*</span></span></code></pre></div><p>This pattern matches any method starting with <strong>authenticate</strong> in any file within the security package.</p><h2 id="viewing-critical-changes-in-merge-requests" tabindex="-1">Viewing Critical Changes in Merge Requests <a class="header-anchor" href="#viewing-critical-changes-in-merge-requests" aria-label="Permalink to &quot;Viewing Critical Changes in Merge Requests&quot;">​</a></h2><p>When a merge request contains critical changes:</p><ol><li>Critical change badges appear at the top of the merge request.</li></ol><p><img src="'+o+'" alt="Bitbucket pull request with critical change badges" width="1133" height="348" data-zoom="true"></p><ol start="2"><li><strong>Critical Changes</strong> section is displayed in the merge request details. Each badge has an expandable section showing: <ul><li>The badge description.</li><li>A table listing all matched critical locations (files or methods).</li><li>Clicking a critical location navigates to that specific file or method.</li></ul></li></ol><p><img src="'+c+'" alt="Critical changes section in the merge request detail view" width="1403" height="1094" data-zoom="true"></p><h2 id="best-practices" tabindex="-1">Best Practices <a class="header-anchor" href="#best-practices" aria-label="Permalink to &quot;Best Practices&quot;">​</a></h2><ul><li><strong>Be specific with patterns</strong> and <strong>use method patterns for precision</strong> in order to avoid overly broad patterns and minimize noise.</li><li><strong>Use meaningful badge titles and descriptions</strong> to aid reviewers in understanding the critical nature of changes.</li><li><strong>Group related patterns</strong> and create separate badges for different critical change categories.</li><li><strong>Keep badge title and text concise</strong> to ensure readability in the UI.</li></ul>',22)])])}const k=i(l,[["render",g]]);export{b as __pageData,k as default};
