import{_ as h,c as d,b as s,x as e,O as i,ak as o,z as t,L as r,o as c}from"./chunks/framework.CM689eR4.js";const k="/assets/teamscale-access-key-1.B13UZoW5.png",g="/assets/teamscale-access-key-2.CzLWJHat.png",u="/assets/teamscale-report-uploader-task.DLnk8rvX.png",m="/assets/artifactory-options.DJGcVtbg.png",y="/assets/artifactory-uploaded-results.C4B3oiLT.png",B=JSON.parse('{"title":"Uploading External Analysis Data to Teamscale (Test Coverage, Findings, Metrics)","description":"","frontmatter":{"title":"Uploading External Analysis Data to Teamscale (Test Coverage, Findings, Metrics)"},"headers":[],"relativePath":"howto/uploading-external-data/index.md","filePath":"howto/uploading-external-data/index.md"}'),E={name:"howto/uploading-external-data/index.md"},f={class:"table-of-contents"},b={href:"#upload-via-command-line"},v={id:"upload-via-command-line",tabindex:"-1"};function F(C,a,T,w,A,x){const p=r("Badge"),l=r("PluginTabsTab"),n=r("PluginTabs");return c(),d("div",null,[a[18]||(a[18]=s("h1",{id:"how-to-upload-external-analysis-data-to-teamscale",tabindex:"-1"},[e("How to Upload External Analysis Data to Teamscale "),s("a",{class:"header-anchor",href:"#how-to-upload-external-analysis-data-to-teamscale","aria-label":'Permalink to "How to Upload External Analysis Data to Teamscale"'},"​")],-1)),a[19]||(a[19]=s("p",null,"It is possible to upload external analysis data to Teamscale, either via the REST API or via repository connectors. External analysis data include test coverage reports, test execution results, custom findings, custom metrics and more.",-1)),s("nav",f,[s("ul",null,[a[2]||(a[2]=s("li",null,[s("a",{href:"#upload-via-web-ui"},"Upload via Web UI")],-1)),s("li",null,[s("a",b,[a[0]||(a[0]=e("Upload via Command Line",-1)),i(p,{text:"recommended",type:"tip"})]),a[1]||(a[1]=s("ul",null,[s("li",null,[s("a",{href:"#specifying-the-teamscale-access-key"},"Specifying the Teamscale access key")]),s("li",null,[s("a",{href:"#manually-specifiying-the-commit-to-upload-to"},"Manually specifiying the commit to upload to")]),s("li",null,[s("a",{href:"#uploading-multiple-report-files-of-the-same-format"},"Uploading Multiple Report Files of the Same Format")]),s("li",null,[s("a",{href:"#uploading-multiple-files-with-different-formats"},"Uploading Multiple Files with Different Formats")])],-1))]),a[3]||(a[3]=o('<li><a href="#upload-via-github-action">Upload via GitHub Action</a></li><li><a href="#upload-via-rest-api">Upload via REST API</a><ul><li><a href="#prerequisites">Prerequisites</a></li><li><a href="#uploading-a-single-report">Uploading a single report</a></li><li><a href="#uploading-data-for-historic-dates-or-revisions">Uploading data for historic dates or revisions</a></li><li><a href="#uploading-multiple-reports-at-once-sessions">Uploading Multiple Reports At Once (Sessions)</a></li></ul></li><li><a href="#upload-via-gradle-plugin">Upload via Gradle Plugin</a></li><li><a href="#upload-via-maven-plugin">Upload via Maven Plugin</a></li><li><a href="#uploading-from-jenkins">Uploading from Jenkins</a></li><li><a href="#upload-from-azure-devops">Upload from Azure DevOps</a></li><li><a href="#import-via-artifactory-s3">Import via Artifactory / S3</a><ul><li><a href="#layout-prerequisites">Layout Prerequisites</a></li><li><a href="#configuration-steps">Configuration Steps</a></li><li><a href="#configuration-example">Configuration Example</a></li></ul></li><li><a href="#storing-analysis-results-in-an-external-storage-system">Storing analysis results in an external storage system</a><ul><li><a href="#configuring-teamscale-to-store-external-analysis-data-in-s3">Configuring Teamscale to Store External Analysis Data in S3</a></li><li><a href="#configuring-uploads">Configuring Uploads</a></li><li><a href="#disabling-external-storage-backends">Disabling External Storage Backends</a></li><li><a href="#migrating-external-analysis-data-between-storage-systems">Migrating External Analysis Data Between Storage Systems</a></li></ul></li>',8))])]),a[20]||(a[20]=s("h2",{id:"upload-via-web-ui",tabindex:"-1"},[e("Upload via Web UI "),s("a",{class:"header-anchor",href:"#upload-via-web-ui","aria-label":'Permalink to "Upload via Web UI"'},"​")],-1)),a[21]||(a[21]=s("p",null,[e("For testing and debugging purposes it can sometimes be helpful to "),s("a",{href:"./../../reference/ui/project/project/#manual-report-upload"},"manually upload reports via the Web UI"),e(".")],-1)),s("h2",v,[a[4]||(a[4]=e("Upload via Command Line",-1)),i(p,{text:"recommended",type:"tip"}),a[5]||(a[5]=e()),a[6]||(a[6]=s("a",{class:"header-anchor",href:"#upload-via-command-line","aria-label":'Permalink to "Upload via Command Line<Badge text="recommended" type="tip" />"'},"​",-1))]),a[22]||(a[22]=o('<p>With <a href="https://github.com/cqse/teamscale-upload/releases/latest" target="_blank" rel="noreferrer">our command line utility <code>teamscale-upload</code></a> for Windows, Linux and macOS you can easily upload external analysis reports to Teamscale.</p><p>The CQSE website offers the <strong>latest version</strong> of the <code>teamscale-upload</code> utility for download. Moreover, you can choose between a jlink version for Windows, Linux, macOS or a native graalvm-based version.</p><ul><li><strong>Download for Windows (jlink, x86_64):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-windows-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-windows-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-windows-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-windows-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-windows-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-windows-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li><li><strong>Download for Linux (jlink, x86_64):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-linux-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-linux-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-linux-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-linux-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-linux-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-linux-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li><li><strong>Download for macOS (jlink, aarch64):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-macos-aarch64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-macos-aarch64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-macos-aarch64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-macos-aarch64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-macos-aarch64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-macos-aarch64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li><li><strong>Download for macOS (jlink, x86_64):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-macos-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-macos-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-jlink-macos-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-macos-x86_64.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-macos-x86_64.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-jlink-macos-x86_64.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li><li><strong>Download for Windows (native):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-windows.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-windows.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-windows.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-windows.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-windows.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-windows.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li><li><strong>Download for Linux (native):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-linux.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-linux.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-linux.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-linux.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-linux.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-linux.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li><li><strong>Download for macOS (native):</strong><ul><li><strong>Latest Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-mac.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-mac.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/latest/teamscale-upload-mac.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>)</li><li><strong>Older Version:</strong> <a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-mac.zip" target="_blank" rel="noreferrer">https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-mac.zip</a> (<a href="https://downloads.teamscale.com/ide/ts-upload/vX.Y.Z/teamscale-upload-mac.zip.sha256" target="_blank" rel="noreferrer">SHA256 checksum</a>) (replacing X.Y.Z by the feature version you need, e.g., v2.9.9)</li></ul></li></ul><p>The distribution contains the teamscale-upload tool and a corresponding Java execution environment (JVM) packed into a zip archive. To use the tool unpack the archive and call the executable (<code>teamscale-upload/bin/teamscale-upload</code>). Run <code>teamscale-upload/bin/teamscale-upload --help</code> to see all available options.</p><p>If you want to upload a report file from your CI pipeline, you can run:</p>',5)),i(n,{sharedStateKey:"buildtool"},{default:t(()=>[i(l,{label:"Maven"},{default:t(()=>[...a[7]||(a[7]=[s("div",{class:"language-bash vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"bash"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-upload/bin/teamscale-upload"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," http://"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"<"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"TEAMSCALE_UR"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"L"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --project"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PROJEC"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"T"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --user"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"USE"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"R"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --accesskey"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"ACCESSKE"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"Y"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --partition"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PARTITIO"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"N"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --format"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," jacoco"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," **"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"/target/site/jacoco/"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"**"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},".xml")])])])],-1)])]),_:1}),i(l,{label:"Gradle"},{default:t(()=>[...a[8]||(a[8]=[s("div",{class:"language-bash vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"bash"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-upload/bin/teamscale-upload"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," http://"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"<"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"TEAMSCALE_UR"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"L"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --project"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PROJEC"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"T"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --user"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"USE"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"R"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --accesskey"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"ACCESSKE"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"Y"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --partition"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PARTITIO"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"N"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --format"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," jacoco"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," **"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"/build/reports/jacoco/"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}},"**"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},".xml")])])])],-1),s("div",{class:"tip custom-block"},[s("p",{class:"custom-block-title"},"Gradle Plugin"),s("p",null,[e("When using our Gradle Plugin it is not necessary to upload the report manually. There is a Gradle task for this. See "),s("a",{href:"#upload-via-gradle-plugin"},"Upload via Gradle Plugin")])],-1)])]),_:1}),i(l,{label:"Other"},{default:t(()=>[...a[9]||(a[9]=[s("div",{class:"language-bash vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"bash"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale-upload/bin/teamscale-upload"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --server"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," http://"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"<"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"TEAMSCALE_UR"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"L"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --project"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PROJEC"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"T"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --user"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"USE"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"R"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --accesskey"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"ACCESSKE"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"Y"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --partition"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PARTITIO"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"N"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#005CC5","--shiki-dark":"#79B8FF"}}," --format"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"FORMA"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"T"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," <"),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"PATH/TO/REPORT/FIL"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"E"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},">")])])])],-1)])]),_:1})]),_:1}),a[23]||(a[23]=o(`<p>Every upload of external results needs to be linked to a commit in order to understand which exact versions were used during testing. This command will automatically detect the version control commit to which the report belongs by querying your CI system (if it is supported, e.g. Jenkins, Azure DevOps, ...) or any Git or SVN checkout in the current working directory. If you want to specify the commit manually see <a href="#manually-specifiying-the-commit-to-upload-to">here</a>.</p><p>Choosing the correct format (<code>--format</code>) is crucial. Otherwise, Teamscale cannot interpret the report file and will log errors to the Worker Log. It must be one of the <a href="./../../reference/upload-formats-and-samples/#supported-formats-for-upload">formats supported by Teamscale</a>. Casing does not matter.</p><p><code>teamscale-upload</code> will exit with code 0 if the upload was fully successful. Any other exit code indicates a problem that you must address. The problem is logged to the console.</p><p>Run <code>teamscale-upload --help</code> to see all available options.</p><div class="warning custom-block"><p class="custom-block-title">Necessary Permissions in Teamscale</p><p>The user you supply on the command line must have the <em>Perform External Uploads</em> permission for the project to which you are uploading the reports. For a production setup we recommend that you create a technical user in Teamscale and assign it the <em>Build</em> role for that project.</p></div><div class="warning custom-block"><p class="custom-block-title">Self-Signed Certificates</p><p>If you&#39;re accessing Teamscale via HTTPS and are signing the certificates yourself or via an internal CA, you can simplify the initial setup of this tool by using <code>--insecure</code>. This will disable certificate validation.</p><p>Once you&#39;re successfully uploading your analysis results, you can re-enable validation and <a href="./../configuring-https/#creating-a-keystore">provide the necessary certificates as a Java key store</a> via <code>--trusted-keystore</code>.</p></div><h3 id="specifying-the-teamscale-access-key" tabindex="-1">Specifying the Teamscale access key <a class="header-anchor" href="#specifying-the-teamscale-access-key" aria-label="Permalink to &quot;Specifying the Teamscale access key&quot;">​</a></h3><p><code>teamscale-upload</code> offers two ways to securely specify the Teamscale <a href="./../../glossary/#access-key">access key</a>:</p><ul><li>Via specifying the environment variable <code>$TEAMSCALE_ACCESS_KEY</code></li><li>Example:</li></ul><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>$ export TEAMSCALE_ACCESS_KEY=&lt;key&gt;</span></span>
<span class="line"><span>$ teamscale-upload --server http://&lt;TEAMSCALE_URL&gt; --project &lt;PROJECT&gt; --user &lt;USER&gt; --partition &lt;PARTITION&gt; --format &lt;FORMAT&gt; &lt;PATH/TO/REPORT/FILE&gt;</span></span></code></pre></div><ul><li>Via the standard input by specifying <code>accesskey -</code> and then entering the key via <em>stdin</em>.</li><li>Example:</li></ul><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>$ cat ~/accesskey.txt | teamscale-upload --server http://&lt;TEAMSCALE_URL&gt; --project &lt;PROJECT&gt; --user &lt;USER&gt; --accesskey - --partition &lt;PARTITION&gt; --format &lt;FORMAT&gt; &lt;PATH/TO/REPORT/FILE&gt;</span></span></code></pre></div><h4 id="additional-way-to-specify-the-teamscale-access-key-not-recommended" tabindex="-1">Additional way to specify the Teamscale access key (not recommended) <a class="header-anchor" href="#additional-way-to-specify-the-teamscale-access-key-not-recommended" aria-label="Permalink to &quot;Additional way to specify the Teamscale access key (not recommended)&quot;">​</a></h4><p>There is one additional unrecommended way to specify the Teamscale access key: Entering it directly via the command-line option <code>--accesskey &lt;key&gt;</code>. As it leaks the provided key to the standard output in an uncensored fashion, it should only be used when the above options are not applicable.</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>$ teamscale-upload --server http://&lt;TEAMSCALE_URL&gt; --project &lt;PROJECT&gt; --user &lt;USER&gt; --accesskey &lt;key&gt; --partition &lt;PARTITION&gt; --format &lt;FORMAT&gt; &lt;PATH/TO/REPORT/FILE&gt;</span></span></code></pre></div><h3 id="manually-specifiying-the-commit-to-upload-to" tabindex="-1">Manually specifiying the commit to upload to <a class="header-anchor" href="#manually-specifiying-the-commit-to-upload-to" aria-label="Permalink to &quot;Manually specifiying the commit to upload to&quot;">​</a></h3><p>If you want to manually enter a commit you can do so with the <code>--commit</code> parameter. It allows the following formats:</p><ul><li>The identifier of the supported VCS: <ul><li>SHA Hash of the commit: e.g. <code>0842320ef195b2d9190ab32b2d24b4a77eb522b1</code></li><li>SVN revision number: e.g. <code>1352456</code></li><li>Team Foundation changeset ID: e.g. <code>1567</code></li></ul></li></ul><p>It is also possible to use <code>--branch-and-timestamp</code>. For details on this format please refer to the <a href="./../../glossary/#branch-and-timestamp">glossary</a>.</p><h3 id="uploading-multiple-report-files-of-the-same-format" tabindex="-1">Uploading Multiple Report Files of the Same Format <a class="header-anchor" href="#uploading-multiple-report-files-of-the-same-format" aria-label="Permalink to &quot;Uploading Multiple Report Files of the Same Format&quot;">​</a></h3><p>If you need to upload more than one file of the same format, you can either specify more than one path on the command line or use wildcards:</p><ul><li><code>*</code> matches any number of characters in the current directory or file name</li><li><code>**</code> matches any number of nested directories</li><li><code>?</code> matches any single character</li></ul><div class="warning custom-block"><p class="custom-block-title">Always Use Single Quotes Around Wildcard Strings</p><p>Since <code>*</code> and <code>?</code> are characters that are also interpreted by your shell, you must always use single quotes around paths with wildcards.</p></div><p>E.g. <code>&#39;path/**/report*.xml&#39;</code> matches all of the following:</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>path/to/nested/report.xml</span></span>
<span class="line"><span>path/report.xml</span></span>
<span class="line"><span>path/report123.xml</span></span></code></pre></div><h3 id="uploading-multiple-files-with-different-formats" tabindex="-1">Uploading Multiple Files with Different Formats <a class="header-anchor" href="#uploading-multiple-files-with-different-formats" aria-label="Permalink to &quot;Uploading Multiple Files with Different Formats&quot;">​</a></h3><p>If you need to upload more than one type of report, e.g. test coverage results and findings, you can use an input file. In this file, you can define multiple formats and one or more patterns per format, e.g:</p><div class="language-ini vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">ini</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">[jacoco]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">jacoco1/**.xml</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">jacoco2/**.xml</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">[findbugs]</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">pattern1/**.findbugs.xml</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">pattern2/**.findbugs.xml</span></span></code></pre></div><p>Use this file with the <code>--input</code> command line option:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">teamscale-upload</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --server</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> http://</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">TEAMSCALE_UR</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">L</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --project</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PROJEC</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">T</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">USE</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">R</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --accesskey</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">ACCESSKE</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">Y</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --partition</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PARTITIO</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">N</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --input</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PATH/TO/INPUT/FIL</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">E</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span></span></code></pre></div><h2 id="upload-via-github-action" tabindex="-1">Upload via GitHub Action <a class="header-anchor" href="#upload-via-github-action" aria-label="Permalink to &quot;Upload via GitHub Action&quot;">​</a></h2><p>If you are using GitHub as your CI system we recommend using teamscale-upload via GitHub Action which is available on the <a href="https://github.com/marketplace/actions/teamscale-upload" target="_blank" rel="noreferrer">GitHub Marketplace</a>. It provides the same options as teamscale-upload and can be used as follows:</p><div class="language-yaml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">yaml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">uses</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;cqse/teamscale-upload-action@v2.9.5&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">    with</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">:</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      server</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;https://demo.teamscale.com&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      project</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;teamscale-upload&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      user</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;build&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      partition</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;Github Action &gt; Linux Branch And Timestamp&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      accesskey</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">\${{ secrets.ACCESS_KEY }}</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      format</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;SIMPLE&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      message</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;This is a test message.&#39;</span></span>
<span class="line"><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">      files</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">: </span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;test_resources/coverage.simple test_resources/coverage2.simple&#39;</span></span></code></pre></div><p>A more detailed description of the parameters can be found <a href="https://github.com/cqse/teamscale-upload-action/blob/master/action.yml" target="_blank" rel="noreferrer">here</a>.</p><h2 id="upload-via-rest-api" tabindex="-1">Upload via REST API <a class="header-anchor" href="#upload-via-rest-api" aria-label="Permalink to &quot;Upload via REST API&quot;">​</a></h2><p>If you cannot use the <code>teamscale-upload</code> utility, you can also manually upload files via our REST API. We do recommend that you use <code>teamscale-upload</code> if possible since it includes helpful handling for many common errors, typos, etc.</p><p>The REST service <code>external-analysis/session/&lt;SESSION_ID&gt;/report</code> allows uploading results from analysis tools like <a href="https://spotbugs.github.io/" target="_blank" rel="noreferrer">FindBugs/SpotBugs</a> or different <a href="./../../reference/supported-technologies/test-coverage/">coverage tools</a>.</p><h3 id="prerequisites" tabindex="-1">Prerequisites <a class="header-anchor" href="#prerequisites" aria-label="Permalink to &quot;Prerequisites&quot;">​</a></h3><p>In order to upload a report to Teamscale, the server which is running the Teamscale instance must be accessible via HTTP(S).</p><p>As a first step, create a new user which will be able to upload external analysis results to Teamscale. You can either use your administration account for this, or better use a special user with the <code>Build</code> role.</p><h3 id="uploading-a-single-report" tabindex="-1">Uploading a single report <a class="header-anchor" href="#uploading-a-single-report" aria-label="Permalink to &quot;Uploading a single report&quot;">​</a></h3><p>To upload a single external analysis report to Teamscale for the current HEAD commit (see below for <a href="#uploading-data-for-historic-dates-or-revisions">uploads for historic dates</a>), issue the following HTTP request:</p><ul><li><p><strong>HTTP method</strong>: <code>POST</code></p></li><li><p><strong>Request URL</strong>:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">http://</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;YOUR_TEAMSCALE_SERVER&gt;:&lt;PORT&gt;/api/v2026.1/projects/&lt;TEAMSCALE_PROJECT_ID&gt;/external-analysis/session/auto-create/report?format=&lt;FORMAT&gt;&amp;partition</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=&lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">PARTITION</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;&amp;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">message</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=&lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">MESSAGE</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span></span></code></pre></div><ul><li><code>YOUR_TEAMSCALE_SERVER:PORT</code> is the address and port of the Teamscale instance.</li><li><code>TEAMSCALE_PROJECT_ID</code> is the ID of the Teamscale project into which to store the coverage.</li><li><code>FORMAT</code> is the report format of the uploaded file. It must be one of the <a href="./../../reference/upload-formats-and-samples/#supported-formats-for-upload">formats supported by Teamscale</a>.</li><li><code>PARTITION</code> is a logical name for the type of coverage. All coverage with the same partition will be grouped together. This, e.g., allows you to upload both coverage for your Java and your JavaScript tests without the results of one overriding those of the other. The name is descriptive and can be any arbitrary string.</li><li><code>MESSAGE</code> is the message shown in the Activity perspective to the user. It should make clear that coverage was uploaded.</li></ul></li><li><p><strong>Body</strong>: Form data. May contain any number of elements with name &quot;report&quot; and the content of a single result XML file.</p></li><li><p><strong>Authentication</strong>: HTTP Basic Authentication with the build or admin user and their Access Token (<strong>not</strong> their password!)</p></li></ul><h4 id="sample-upload-with-curl" tabindex="-1">Sample Upload with Curl <a class="header-anchor" href="#sample-upload-with-curl" aria-label="Permalink to &quot;Sample Upload with Curl&quot;">​</a></h4><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --request</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --form</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;report=@coverage.xml&quot;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;http://teamscale-server:8080/api/v2026.1/projects/myProject/external-analysis/session/auto-create/report?format=JACOCO&amp;partition=Unit%20Tests&amp;message=Unit%20Test%20Coverage&quot;</span></span></code></pre></div><div class="warning custom-block"><p class="custom-block-title">Always Quote the URL</p><p>Please note that the URL must be enclosed in quotes. This is required as most shells treat the <code>&amp;</code> character specially and would thus truncate the URL. If you are not sure you quoted the URL correctly, you can use <code>curl -v</code> to get verbose output from curl, including the actual URL it tries to contact.</p></div><div class="warning custom-block"><p class="custom-block-title">File encoding</p><p>If not explicitly specified, Teamscale will interpret the encoding of the provided file based on it&#39;s BOM, or default to UTF-8. Change the <code>charset</code> of the <code>Content-Type</code> header when uploading a Teamscale report via <code>curl</code> to prevent parsing errors because of misinterpreted encodings.</p></div><p>An example how to upload a report with a specified UTF-16 encoding:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --request</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --form</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;report=@coverage.xml;type=text/xml;charset=UTF-16&quot;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;http://teamscale-server:8080/api/v2026.1/projects/myProject/external-analysis/session/auto-create/report?format=JACOCO&amp;partition=Unit%20Tests&amp;message=Unit%20Test%20Coverage&quot;</span></span></code></pre></div><p>Note the type definition <code>type=text/xml;charset=UTF-16</code> after the file name.</p><div class="tip custom-block"><p class="custom-block-title">Request Parameters</p><p>Details about the service&#39;s parameters can be best retrieved via the online service documentation as <a href="./../../reference/rest-api/#available-rest-services">described here</a>.</p></div><p>In addition to the <a href="./../../reference/rest-api/#common-pitfalls">common pitfalls when dealing with the REST API</a>, you need to check if the external tool is activated in the project&#39;s analysis profile.</p><p>Furthermore, please refer to the <a href="./../../reference/upload-formats-and-samples/">details for supported upload formats</a>.</p><h3 id="uploading-data-for-historic-dates-or-revisions" tabindex="-1">Uploading data for historic dates or revisions <a class="header-anchor" href="#uploading-data-for-historic-dates-or-revisions" aria-label="Permalink to &quot;Uploading data for historic dates or revisions&quot;">​</a></h3><p>Note that the uploaded results will be used for the current HEAD commit in Teamscale on the main branch (e.g., latest commit on master for Git, latest changeset on the TFS main branch or latest commit on trunk for SVN). Should this not be the behaviour you want, you can override this by adding the following to the request&#39;s URL:</p><p><code>&amp;revision=&lt;REVISION&gt;</code></p><p>where REVISION is, depending on your version control system, a:</p><ul><li>full Git SHA hash, or</li><li>SVN revision number, or</li><li>TFS changeset ID</li></ul><div class="warning custom-block"><p class="custom-block-title">Use only during session creation</p><p>Note that the <code>revision</code> parameter has to be supplied <a href="#uploading-multiple-reports-at-once-sessions">when creating the session</a>. It will <strong>not</strong> work for individual uploads.</p><p>Please refer to <a href="./../../reference/rest-api/">interactive REST API documentation</a> to view all parameters.</p></div><p>Regardless of whether the revision has already been analyzed or not, Teamscale will store the external analysis data for the code with the revision. When later it is analyzed, the upload is integrated with the revision into Teamscale.</p><p>If concerned project has a multi-connector setup, the VCS repository that contains the revision for which an upload is meant, can be specified in the request&#39;s URL using the repository identifier (see <a href="./../../reference/connector-options/#shared-connector-options">connector options</a>) for the project connector:</p><p><code>&amp;repository=&lt;REPOSITORY_IDENTIFIER&gt;</code></p><p>Teamscale also supports uploading external analysis data to timestamps. This can be achieved by adding the following to the request&#39;s URL:</p><p><code>&amp;t=&lt;TIMESTAMP&gt;</code></p><p>If you additionally need to specify the branch for the upload, you can use the <code>t</code> parameter as well:</p><p><code>&amp;t=&lt;BRANCH&gt;:&lt;TIMESTAMP&gt;</code></p><h3 id="uploading-multiple-reports-at-once-sessions" tabindex="-1">Uploading Multiple Reports At Once (Sessions) <a class="header-anchor" href="#uploading-multiple-reports-at-once-sessions" aria-label="Permalink to &quot;Uploading Multiple Reports At Once (Sessions)&quot;">​</a></h3><p>If you want to upload multiple reports in a single logical commit, you should use Teamscale&#39;s session concept. For session handling, the service <code>external-analysis/session</code> is used. The following example uploads two different reports as a single commit using <em>curl</em>. For more details, see the <a href="./../../reference/rest-api/#available-rest-services">service documentation</a>.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --request</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> http://localhost:8080/api/v2026.1/projects/my-project-id/external-analysis/session?message=myMessage</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&amp;partition</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">myPartition</span></span></code></pre></div><p>This command will return the session ID, in this case <code>Sdfb38cb0-c348-40fb-82f0-144bf0e41beb</code>. Using this session, we can upload multiple reports.</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --request</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --form</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;report=@./MyReport.xml&quot;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> http://localhost:8080/api/v2026.1/projects/myProject/external-analysis/session/Sdfb38cb0-c348-40fb-82f0-144bf0e41beb/report?format=FINDBUGS</span></span></code></pre></div><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --request</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --form</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;report=@./OtherReport.xml&quot;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> http://localhost:8080/api/v2026.1/projects/myProject/external-analysis/session/Sdfb38cb0-c348-40fb-82f0-144bf0e41beb/report?format=FXCOP</span></span></code></pre></div><p>Finally, we commit the session using a POST request:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --request</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --user</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> bob:e434mikm35d</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> http://localhost:8080/api/v2026.1/projects/my-project-id/external-analysis/session/Sdfb38cb0-c348-40fb-82f0-144bf0e41beb</span></span></code></pre></div><h2 id="upload-via-gradle-plugin" tabindex="-1">Upload via Gradle Plugin <a class="header-anchor" href="#upload-via-gradle-plugin" aria-label="Permalink to &quot;Upload via Gradle Plugin&quot;">​</a></h2><p>With our <a href="./../../reference/integrations/gradle-plugin/">Teamscale Gradle Plugin</a> you can easily upload artifacts directly from Gradle without any additional tooling involved. It can automate uploading arbitrary reports. It has special support for JUnit, JaCoCo, <a href="./../../reference/upload-formats-and-samples/teamscale-compact-coverage/">Compact Coverage</a> and <a href="./../../reference/upload-formats-and-samples/testwise-coverage/">Testwise Coverage</a>, which means that you can just point the plugin to the corresponding task that creates the report and it will take care of wiring up the report to the upload task. This guide expects that you have already configured your test tasks and the <a href="https://docs.gradle.org/current/userguide/jacoco_plugin.html" target="_blank" rel="noreferrer">jacoco plugin</a>.</p><div class="tip custom-block"><p class="custom-block-title">Test Impact Analysis</p><p>For more in depth instructions on how to set up Testwise Coverage collection and Impacted Test execution please refer to our <a href="./../../tutorial/tia-java/">tutorial</a>.</p></div><p>You can apply the plugin by adding it to your plugins block of the top level project.</p>`,78)),i(n,{sharedStateKey:"gradle_lang"},{default:t(()=>[i(l,{label:"Groovy"},{default:t(()=>[...a[10]||(a[10]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"plugins {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    id "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.teamscale"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," version "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"35.0.2"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),i(l,{label:"Kotlin DSL"},{default:t(()=>[...a[11]||(a[11]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"plugins"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    id"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"com.teamscale"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") version "),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"35.0.2"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[24]||(a[24]=s("p",null,[e("The "),s("code",null,"teamscale"),e(" extension allows you to configure where reports should be uploaded to:")],-1)),i(n,{sharedStateKey:"gradle_lang"},{default:t(()=>[i(l,{label:"Groovy"},{default:t(()=>[...a[12]||(a[12]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    server {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        url "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," 'https://mycompany.teamscale.io/'")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        project "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," 'test'")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userName "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}}," 'build'")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userAccessToken "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," property("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'teamscale.access-token'"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),i(l,{label:"Kotlin DSL"},{default:t(()=>[...a[13]||(a[13]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    server"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        url "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "https://mycompany.teamscale.io/"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        project "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "test"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userName "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "build"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        userAccessToken "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," System."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"getProperty"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"teamscale.access-token"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[25]||(a[25]=o('<p>The example assumes that you pass the Teamscale Access Token to Gradle via</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">gradle</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -Pteamscale.access-token=82l1jtkIx6xG7DDG34FLsKhejcHz1cMu</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> ...</span></span></code></pre></div><p>By default the plugin will detect the commit it needs to upload to from either the environment variables set in the CI pipelines or from the current Git checkout. In case none of these work in your setup, you need to specify the commit hash manually:</p>',3)),i(n,{sharedStateKey:"gradle_lang"},{default:t(()=>[i(l,{label:"Groovy"},{default:t(()=>[...a[14]||(a[14]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"teamscale {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    commit {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        revision "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}}," System."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"getenv("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'MY_ENV_COMMIT_SHA'"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),i(l,{label:"Kotlin DSL"},{default:t(()=>[...a[15]||(a[15]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"teamscale"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    commit"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"        revision "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," System."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"getenv"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"MY_ENV_COMMIT_SHA"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},")")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    }")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[26]||(a[26]=s("p",null,[e("The "),s("code",null,"TeamscaleUpload"),e(" task allows you to upload reports to Teamscale:")],-1)),i(n,{sharedStateKey:"gradle_lang"},{default:t(()=>[i(l,{label:"Groovy"},{default:t(()=>[...a[16]||(a[16]=[s("div",{class:"language-groovy vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"groovy"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"import"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}}," com.teamscale.TeamscaleUpload")]),e(`
`),s("span",{class:"line"}),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"register("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},"'teamscaleTestUpload'"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},", "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"TeamscaleUpload"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    partition "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "Unit Tests"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    from(tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"test) "),s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// Test task")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    from(tasks"),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"."),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"jacocoTestReport) "),s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// JacocoReport task")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1}),i(l,{label:"Kotlin DSL"},{default:t(()=>[...a[17]||(a[17]=[s("div",{class:"language-kotlin vp-adaptive-theme"},[s("button",{title:"Copy Code",class:"copy"}),s("span",{class:"lang"},"kotlin"),s("pre",{class:"shiki shiki-themes github-light github-dark vp-code",tabindex:"0"},[s("code",null,[s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"import"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}}," com.teamscale.TeamscaleUpload")]),e(`
`),s("span",{class:"line"}),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"tasks."),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"register"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"<"),s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"TeamscaleUpload"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},">("),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},'"teamscaleTestUpload"'),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},") {")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"    partition "),s("span",{style:{"--shiki-light":"#D73A49","--shiki-dark":"#F97583"}},"="),s("span",{style:{"--shiki-light":"#032F62","--shiki-dark":"#9ECBFF"}},' "Unit Tests"')]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    from"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"(tasks.test) "),s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// Test task")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#6F42C1","--shiki-dark":"#B392F0"}},"    from"),s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"(tasks.jacocoTestReport) "),s("span",{style:{"--shiki-light":"#6A737D","--shiki-dark":"#6A737D"}},"// JacocoReport task")]),e(`
`),s("span",{class:"line"},[s("span",{style:{"--shiki-light":"#24292E","--shiki-dark":"#E1E4E8"}},"}")])])])],-1)])]),_:1})]),_:1}),a[27]||(a[27]=o(`<p><code>from(task)</code> supports tasks of the following types:</p><ul><li><code>Test</code> will upload the resulting JUnit XML reports (if <code>reports.junitXml.required</code> is enabled) containing information about the tests that were executed, their durations and results. This does not include test coverage.</li><li><code>JacocoReport</code> will upload the resulting JaCoCo XML report. This contains test coverage, but no test execution results.</li><li><code>CompactCoverageReport</code> will upload the resulting <a href="./../../reference/upload-formats-and-samples/teamscale-compact-coverage/">Compact Coverage</a> report. Similar to the JaCoCo report, this report contains test coverage but with a smaller footprint that consumes less storage; it should be preferred over JaCoCo.</li><li><code>TestwiseCoverageReport</code> will upload the resulting <a href="./../../reference/upload-formats-and-samples/testwise-coverage/">Testwise Coverage</a> report. This contains test coverage and test execution information. In contrast to JaCoCo and Compact Coverage, Testwise Coverage holds test coverage per test case.</li></ul><p><code>addReport(format, reportFiles)</code> allows you to also upload any other reports (see <a href="./../../reference/upload-formats-and-samples/">Upload Formats</a>)</p><p>You can run this as part of your CI Gradle command like this:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">gradle</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --continue</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> test</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> teamscaleTestUpload</span></span></code></pre></div><p><code>--continue</code> tells Gradle to upload the reports even when the tests failed.</p><p>For more details have a look at the <a href="./../../reference/integrations/gradle-plugin/">plugin reference documentation</a>.</p><h2 id="upload-via-maven-plugin" tabindex="-1">Upload via Maven Plugin <a class="header-anchor" href="#upload-via-maven-plugin" aria-label="Permalink to &quot;Upload via Maven Plugin&quot;">​</a></h2><p>Analogously to the Gradle plugin, there is a <a href="https://mvnrepository.com/artifact/com.teamscale/teamscale-maven-plugin" target="_blank" rel="noreferrer">Teamscale Maven plugin</a> that can be used to upload JaCoCo reports to Teamscale. It can be used to automatically upload Unit, Integration and Aggregate test coverage reports generated by the <a href="https://mvnrepository.com/artifact/org.jacoco/jacoco-maven-plugin" target="_blank" rel="noreferrer">JaCoCo Maven plugin</a> to your Teamscale instance. This guide expects that you have already configured the <a href="https://www.jacoco.org/jacoco/trunk/doc/maven.html" target="_blank" rel="noreferrer">JaCoCo plugin</a>.</p><div class="tip custom-block"><p class="custom-block-title">Recording testwise coverage</p><p>The Teamscale Maven plugin can also be used to directly record and upload test coverage to Teamscale. In addition, it is possible to record testwise coverage with it. Please have a look at our <a href="./../providing-testwise-coverage/#maven-and-junit-5">testwise coverage section</a> for a more detailed example.</p></div><p>The plugin offers a goal called <code>upload-coverage</code> which can be invoked after the JaCoCo test reports have been generated.</p><div class="warning custom-block"><p class="custom-block-title">Check the JaCoCo configuration</p><p>Make sure that JaCoCo is configured to <a href="https://www.jacoco.org/jacoco/trunk/doc/report-mojo.html#formats" target="_blank" rel="noreferrer">generate XML reports</a>.</p></div><p>Configure where reports should be uploaded to by supplying the <code>&lt;teamscaleUrl&gt;</code> and <code>&lt;projectId&gt;</code>. An example configuration could look like this</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;com.teamscale&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">groupId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;teamscale-maven-plugin&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">artifactId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;34.2.2&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">version</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                    &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;upload-coverage&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goal</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">                &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">goals</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">execution</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">executions</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscaleUrl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;http://localhost:8080&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">teamscaleUrl</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">projectId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;my-project&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">projectId</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;build&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">username</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">accessToken</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;6lJKEvNHeTxGPhMAi4D84DWqzoSFL1p4&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">accessToken</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">endCommit</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;master:HEAD&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">endCommit</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">            &lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">unitTestPartition</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;My Custom Unit Tests Partition&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">unitTestPartition</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">        &lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">configuration</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;/</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">plugin</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&gt;</span></span></code></pre></div><p>You can optionally specify an <code>endCommit</code>, if left out the currently checked out commit will be automatically detected from the project&#39;s git repository. You can use <code>unitTestPartition</code> to define the partition to which unit tests should be uploaded to, similar to <code>integrationTestPartition</code> and <code>aggregateTestPartition</code>.</p><p>Invoking <code>mvn com.teamscale:teamscale-maven-plugin:upload-coverage</code> will collect all generated XML reports and upload them to each partition in a single session. If you have a Maven project consisting of multiple submodules, you have to invoke the command in the root project.</p><h2 id="uploading-from-jenkins" tabindex="-1">Uploading from Jenkins <a class="header-anchor" href="#uploading-from-jenkins" aria-label="Permalink to &quot;Uploading from Jenkins&quot;">​</a></h2><p>For Jenkins users we also have a plugin that provides an &quot;after build step&quot; to do the upload. For detailed instructions please see the <a href="https://plugins.jenkins.io/teamscale-upload/" target="_blank" rel="noreferrer">Jenkins plugin page</a>.</p><h2 id="upload-from-azure-devops" tabindex="-1">Upload from Azure DevOps <a class="header-anchor" href="#upload-from-azure-devops" aria-label="Permalink to &quot;Upload from Azure DevOps&quot;">​</a></h2><p>A plugin is provided for directly uploading coverage from TFS / Azure DevOps.</p><p>In order to authenticate against Teamscale, first add a variable to your pipeline that contains a Teamscale <a href="./../../glossary/#access-key">access key</a>. When using the classic editor, you can add it on the &quot;Variables&quot; tab.</p><p><img src="`+k+'" alt="In the classic editor you can use the &quot;Variables&quot; tab for adding variables" width="1411" height="301" data-zoom="true"></p><p>When using a YAML pipeline, you have to open the pipeline for editing, then click on the &quot;Variables&quot; button.</p><p><img src="'+g+'" alt="In the YAML editor you have to click on the &quot;Variables&quot; button in Edit mode for adding variables" width="483" height="638"></p><p>Change the variable type to &quot;secret&quot;.</p><p>Add the task &quot;Teamscale Report Uploader&quot; to your pipeline.</p><p><img src="'+u+`" alt="In the YAML editor you can search for the task name &quot;Teamscale&quot; and add the corresponding &quot;Teamscale Report Uploader&quot; task" width="400" height="302"></p><p>Fill the following parameters:</p><ul><li>Files: <a href="./../../glossary/#ant-pattern">Ant pattern</a> for the reports to be uploaded.</li><li>Report Format ID: You can find all valid IDs on the <a href="./../../reference/upload-formats-and-samples/#supported-formats-for-upload">Supported Upload Formats and Samples</a> page. If you want to upload multiple report formats, you need to add one pipeline task per format.</li><li>Teamscale URL: The URL under which Teamscale is accessible.</li><li>Username: The Teamscale username for which you have generated the Teamscale access key.</li><li>IDE Access Key: The secret variable you have added to the pipeline, e.g. <code>$(teamscaleAccessKey)</code>.</li><li>Teamscale Project: The project ID of the corresponding Teamscale project. You can copy this from the URL when you open the project in Teamscale or find it in the <em>Projects</em> view.</li><li>Partition (see <a href="./../../glossary/#partition">Glossary</a>): An arbitrary name to associate with the report uploads. Note that it&#39;s recommended to have a separate partition per pipeline and per report format, e.g. <code>My Pipeline - Cobertura</code>.</li><li>Path to CodeCoverage.exe (optional): This must be defined if you want to upload a binary Visual Studio coverage file. The task will use this to convert the binary file to an XML file before the upload. For detailed instructions on how to convert the coverage files, see the <a href="./../setting-up-profiler-tga/cs/#visual-studio-tfs-mstest-code-coverage">TFS / AzureDevOps Section</a>.</li></ul><p>The task will automatically resolve which revision it&#39;s running for, and will use this revision for the upload.</p><h2 id="import-via-artifactory-s3" tabindex="-1">Import via Artifactory / S3 <a class="header-anchor" href="#import-via-artifactory-s3" aria-label="Permalink to &quot;Import via Artifactory / S3&quot;">​</a></h2><p>External analysis data can be directly imported to Teamscale via the Artifactory or S3 repository connector. The connector will extract the results from the repository, process the reports and store them in the configured partition.</p><h3 id="layout-prerequisites" tabindex="-1">Layout Prerequisites <a class="header-anchor" href="#layout-prerequisites" aria-label="Permalink to &quot;Layout Prerequisites&quot;">​</a></h3><p>Before importing external analysis data to Teamscale via Artifactory / S3, please ensure the following:</p><ul><li>All relevant external results reports are available in Artifactory / S3.</li><li>The external results reports are packed in archives (i.e. ZIP files).</li><li>The folder structure used follows this pattern:<div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>/ arbitrarily / many / directories / before / the / upload / root</span></span>
<span class="line"><span>   / &#39;uploads&#39;</span></span>
<span class="line"><span>   / &lt;branch name&gt; </span></span>
<span class="line"><span>   / &lt;commit timestamp in ms (Java long)&gt;[-&lt;commit hash&gt;]?</span></span>
<span class="line"><span>   / &lt;upload partition&gt; </span></span>
<span class="line"><span>   / &lt;artifact type (EReportFormat, case insensitive), e.g. &#39;jacoco&#39;&gt; </span></span>
<span class="line"><span>   / none / or / some / intermediate / directories /</span></span>
<span class="line"><span>   / &lt;Zip archive file&gt;</span></span></code></pre></div>All profilers / upload tools provided with Teamscale follow this format automatically, making it easy to configure. If you use your own schema, make sure to adapt the extraction patterns accordingly.</li></ul><h3 id="configuration-steps" tabindex="-1">Configuration Steps <a class="header-anchor" href="#configuration-steps" aria-label="Permalink to &quot;Configuration Steps&quot;">​</a></h3><p>To import external results reports to a project:</p><ol><li>Add an Artifactory / S3 connector to the project.</li><li>Configure the <a href="./../../reference/connector-options/#artifactory-connector-options">Artifactory connector options</a> so that Teamscale can extract the reports from Artifactory.</li><li>If you used the standard path format as specified in <a href="#layout-prerequisites">Prerequisites</a>, you can skip this step. Otherwise, configure the following options so that Teamscale can process the reports: <ul><li><code>Analysis report mapping</code>: Ant pattern used to map the reports inside the ZIP archives to their corresponding <a href="./../../reference/upload-formats-and-samples/#supported-formats-for-upload">report format</a>. Example: <code>**/junit.xml -&gt; JUNIT, **/jacoco.xml -&gt; JACOCO</code></li><li><code>Partition Pattern</code>: Regular expression used to extract the partition from the path of the artifacts. The first non-null group is used as partition, e.g. <code>/coverage/([^/]+)/</code> would use the sub-folders of coverage as the partition names.</li></ul></li><li>Save the project.</li></ol><h3 id="configuration-example" tabindex="-1">Configuration Example <a class="header-anchor" href="#configuration-example" aria-label="Permalink to &quot;Configuration Example&quot;">​</a></h3><p>Below is the structure of the Artifactory containing the external results reports.</p><ul><li><code>lcov-reports.zip</code> contains the LCOV coverage report (<code>lcov.info</code>).</li><li><code>findings-reports.zip</code> contains the external findings report for findings (<code>warnings.json</code>).</li></ul><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>- MyRepository</span></span>
<span class="line"><span>|</span></span>
<span class="line"><span>| -&gt; MyProjectName</span></span>
<span class="line"><span>  |</span></span>
<span class="line"><span>  | -&gt; uploads</span></span>
<span class="line"><span>    |</span></span>
<span class="line"><span>    | -&gt; master</span></span>
<span class="line"><span>      |</span></span>
<span class="line"><span>      | -&gt; 1578650400000-4e8afe52737255ba40875a1af1fced1e08fc5316</span></span>
<span class="line"><span>        |</span></span>
<span class="line"><span>        | -&gt; coverage</span></span>
<span class="line"><span>          |</span></span>
<span class="line"><span>          | -&gt; LCOV</span></span>
<span class="line"><span>            |</span></span>
<span class="line"><span>            | -&gt; lcov-reports.zip</span></span>
<span class="line"><span>        |</span></span>
<span class="line"><span>        | -&gt; findings</span></span>
<span class="line"><span>          |</span></span>
<span class="line"><span>          | -&gt; GENERIC_FINDINGS</span></span>
<span class="line"><span>            |</span></span>
<span class="line"><span>            | -&gt; findings-reports.zip</span></span>
<span class="line"><span>      |</span></span>
<span class="line"><span>      | -&gt; 1578651300000-70eb476d01abd0d877d064f57a6da5e14c677687</span></span>
<span class="line"><span>        |</span></span>
<span class="line"><span>        | -&gt; coverage</span></span>
<span class="line"><span>          |</span></span>
<span class="line"><span>          | -&gt; LCOV</span></span>
<span class="line"><span>            |</span></span>
<span class="line"><span>            | -&gt; lcov-reports.zip</span></span></code></pre></div><p>Accordingly, the Artifactory connector&#39;s configuration would look as follows:</p><p><img src="`+m+'" alt="Screenshot of the Artifactory connector&#39;s configuration to upload external results" width="668" height="897" data-zoom="true"></p><p>And this would be the end result and how the uploaded results via Artifactory would appear in Teamscale:</p><p><img src="'+y+'" alt="Screenshot of the uploaded external results via Artifactory" width="2354" height="1076" data-zoom="true"></p><h2 id="storing-analysis-results-in-an-external-storage-system" tabindex="-1">Storing analysis results in an external storage system <a class="header-anchor" href="#storing-analysis-results-in-an-external-storage-system" aria-label="Permalink to &quot;Storing analysis results in an external storage system&quot;">​</a></h2><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>This section does not pertain to <a href="#import-via-artifactory-s3">imports from storage systems</a> and is only concerned with direct uploads to Teamscale.</p></div><p>By default, uploads of external analysis data over the REST API interface offered by Teamscale will be stored in Teamscale&#39;s internal storage. However, Teamscale also provides the option to use an external storage system to store the data. Some advantages of using an external storage backend are:</p><ul><li>Data can be shared over multiple projects without duplicating it, which is especially useful for shadow instances and project copies.</li><li>The size of Teamscale backups is not impacted by external analysis data, as the data is pulled from the external storage during history analysis.</li><li>Dedicated storage services can provide more elaborate data management than Teamscale. For example, automatically pruning old uploads is easier.</li><li>External data might need to be persisted anyway. In this case, duplication is avoided.</li><li>Teamscale can always access the full report data, leading to better analysis results in some rollback scenarios.</li></ul><h3 id="configuring-teamscale-to-store-external-analysis-data-in-s3" tabindex="-1">Configuring Teamscale to Store External Analysis Data in S3 <a class="header-anchor" href="#configuring-teamscale-to-store-external-analysis-data-in-s3" aria-label="Permalink to &quot;Configuring Teamscale to Store External Analysis Data in S3&quot;">​</a></h3><div class="tip custom-block"><p class="custom-block-title">S3 server required</p><p>This requires an S3 server for storage, which is not shipped with Teamscale.</p></div><div class="tip custom-block"><p class="custom-block-title">Required permissions</p><p>This configuration can only be done by users with permissions to create external storage backends.</p></div><ol><li>Create an external account, containing the URL, user and API key. The account has to specify &quot;multiple systems&quot; (default) or &quot;S3&quot; to show up in the following configuration.</li><li>Navigate to <code>Admin -&gt; Storage Backends</code>. This page contains a list of all configured external storage backends (internal storage is not displayed, since it is the default behavior).</li><li>Click <code>New external storage backend</code> to open the configuration dialog.</li></ol><details class="details custom-block"><summary>Click here for a detailed explanation of every field in the dialog.</summary><table tabindex="0"><thead><tr><th>Field Name</th><th>Description</th></tr></thead><tbody><tr><td>Name</td><td>An arbitrary name to identify this storage backend. This can not be changed once the storage backend is created.</td></tr><tr><td>External Account</td><td>Contains the credentials and URL to authenticate with S3. The selected S3 account needs at least creation and deletion permissions on the S3 server to allow uploading data.</td></tr><tr><td>Protocol</td><td>The protocol used by the storage system S3 in this case (other protocols - e.g. Artifactory - will be supported in the future).</td></tr><tr><td>Repository or bucket</td><td>In case of S3, this is the bucket name Teamscale should upload to.</td></tr><tr><td>Upload Path Prefix (Optional)</td><td>By default, Teamscale will upload external data to the root of the selected S3 bucket. This option can be used to specify an optional subdirectory (relative to the S3 bucket root) where the uploads will be stored instead, e.g. <code>teamscale/external-analysis-uploads/</code>.</td></tr><tr><td>Use S3 credentials process</td><td>Same as &quot;Use Credentials Process&quot; in the <a href="./../../reference/connector-options/#s3-connector-options">S3 connector options</a>. If you are not sure about this, we recommend keeping it disabled.</td></tr></tbody></table></details><ol start="4"><li>Once the external storage is configured, it still needs to be enabled to have any effect. There are two ways to enable an external storage: on a global basis, or on a project-by-project basis. <ol><li><p>By default, Teamscale stored uploads internally, along with the rest of its analysis data. To change this default storage location, instead, select one of the configured external storage backends as default. New projects will automatically pre-select the default. Old projects will only use the default after editing the project, including a reanalysis.</p></li><li><p>Sometimes, you may want to migrate projects on a server one-by-one. To change the external storage backend of a project, navigate to the <code>Edit Project</code> page and select the storage backend from the dropdown.</p></li></ol></li></ol><div class="danger custom-block"><p class="custom-block-title">DANGER</p><p>Changing the configuration of the selected storage, e.g., bucket name or path, may change the analysis history of the respective projects, automatically triggering a (partial) re-analysis.</p></div><div class="warning custom-block"><p class="custom-block-title">Copying projects with external storage</p><p>The copy of a project with external storage backend will keep the mapping to the external storage backend of the original project. Thus, it also contains the stored analysis results of the original project. To create a separate external storage backend mapping for the copy, uncheck the &quot;Copy all project data&quot; checkbox. Note that this also omits any external data which was stored in Teamscale before external storage was enabled.</p></div><div class="tip custom-block"><p class="custom-block-title">Changing external storage only takes full effect after project reanalysis.</p><p>The selected storage is only updated once the project is reanalyzed. It is possible to change the selection without reanalysis. In this case, the old selection will remain in use until the project is reanalyzed.</p></div><h3 id="configuring-uploads" tabindex="-1">Configuring Uploads <a class="header-anchor" href="#configuring-uploads" aria-label="Permalink to &quot;Configuring Uploads&quot;">​</a></h3><p>If you are already uploading external analysis data in Teamscale via any of the described upload methods, no changes are required on this end. Once the external storage backend is configured in Teamscale, it will be recognized by Teamscale and uploads will be redirected automatically.</p><h3 id="disabling-external-storage-backends" tabindex="-1">Disabling External Storage Backends <a class="header-anchor" href="#disabling-external-storage-backends" aria-label="Permalink to &quot;Disabling External Storage Backends&quot;">​</a></h3><p>To disable external storage, select &quot;Internal Storage&quot; for the projects which should no longer use the system. This change takes effect on the next project reanalysis.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>Resetting the Teamscale configuration does not delete any data in the external storage system.</p></div><h3 id="migrating-external-analysis-data-between-storage-systems" tabindex="-1">Migrating External Analysis Data Between Storage Systems <a class="header-anchor" href="#migrating-external-analysis-data-between-storage-systems" aria-label="Permalink to &quot;Migrating External Analysis Data Between Storage Systems&quot;">​</a></h3><p>Automated migration between different external storage systems is not supported. However, data can be moved between external storage systems manually, as long as the directory structure stays intact.</p>',66))])}const D=h(E,[["render",F]]);export{B as __pageData,D as default};
