import{_ as t,c as a,ak as s,o}from"./chunks/framework.CM689eR4.js";const p=JSON.parse('{"title":"Best Practices","description":"","frontmatter":{"title":"Best Practices"},"headers":[],"relativePath":"introduction/best-practices/index.md","filePath":"introduction/best-practices/index.md"}'),i={name:"introduction/best-practices/index.md"};function r(n,e,l,c,u,h){return o(),a("div",null,[...e[0]||(e[0]=[s('<h1 id="best-practices-for-static-code-analysis" tabindex="-1">Best Practices for Static Code Analysis <a class="header-anchor" href="#best-practices-for-static-code-analysis" aria-label="Permalink to &quot;Best Practices for Static Code Analysis&quot;">​</a></h1><p>Just installing a tool and hoping that your code quality will improve as a result usually doesn&#39;t work out. Lasting improvements only happen when we can motivate engineers to continuously care for and work on code quality. This will only happen when <a href="./../../introduction/why-many-fail-to-improve/">we make our tools easy and effortless to use</a> and deeply integrate them in our development process and practices. The following sections list best practices that help you become effective at continuously improving software quality in your project.</p><h2 id="choose-a-technical-quality-engineer" tabindex="-1">Choose a Technical Quality Engineer <a class="header-anchor" href="#choose-a-technical-quality-engineer" aria-label="Permalink to &quot;Choose a Technical Quality Engineer&quot;">​</a></h2><p>Every great cause starts with a leader. Someone who champions the cause in the team, makes sure there&#39;s a clear goal and everyone stays on track. For software quality, we like to call this person the <em>technical quality engineer (TQE)</em>.</p><p>The only real requirement for the job is: <strong>They must care deeply about your software system&#39;s quality.</strong> We do however recommend that the role be filled by someone who &quot;lives close to the code&quot; (thus, <em>technical</em> quality engineer), i.e. a full- or part-time developer, since technical knowledge about the code, the system&#39;s architecture and the development process make a TQE&#39;s job much easier.</p><div class="tip custom-block"><p class="custom-block-title">The TQE is responsible for both Teamscale and the quality improvement process.</p><ul><li>The TQE advocate software quality in the team.</li><li>The TQE makes sure that <a href="./../../howto/monitoring-teamscale/">Teamscale is running</a> and properly configured.</li><li>The TQE keeps an eye on the <a href="./../../reference/ui/architecture/">architecture diagram in Teamscale</a> and makes sure the team keeps it up-to-date.</li><li>The TQE <a href="./../../reference/ui/qualitycontrol/reports/">prepares quality trends and interesting findings</a> for each sprint retrospective.</li><li>The TQE makes sure the team turns <a href="./../../reference/ui/delta/#navigating-the-findings-churn">missed findings</a> into backlog items for the next sprint.</li></ul></div><p>In essence, the TQE acts a as a counter-weight to the &quot;daily business&quot;, deadlines and the urge to implement new features at the expense of long-term quality improvements. Our experience is that without such a clear owner for the quality process and tooling, teams won&#39;t achieve lasting improvements.</p><p>This role can be filled by anyone from your team or even an external person. It is not a full-time job but rather requires only a little extra time every sprint.</p><div class="tip custom-block"><p class="custom-block-title">Quality Control as a Service</p><p>For some of our customers, <a href="https://www.cqse.eu/en/consulting/" target="_blank" rel="noreferrer">we from CQSE act as the TQE</a> and bring an unbiased outside perspective to the table. As software quality experts with many years of experience, we challenge the teams regularly and help them tackle their technical debt effectively.</p></div><h2 id="choose-a-quality-goal" tabindex="-1">Choose a Quality Goal <a class="header-anchor" href="#choose-a-quality-goal" aria-label="Permalink to &quot;Choose a Quality Goal&quot;">​</a></h2><p>Don‘t waste your time sorting through endless lists of findings! When you first install a new analysis tool, you&#39;ll probably find thousands of findings. Trying to read these long lists and manually prioritize which findings to address first is tedious and ultimately a doomed strategy as the business expense cannot be justified in the long run. Furthermore, fixing findings all over your system may do more harm than good, e.g. introduce bugs and regressions by accident.</p><p>We recommend a much more cost-effective and less risky approach.</p><div class="tip custom-block"><p class="custom-block-title">Every team agrees on one of the following quality goals.</p><ul><li>Either: <em>at least don&#39;t make the system any worse</em>, i.e. clean up all new problems.</li><li>Or: <em>actively improve the system</em> by cleaning up all changed code.</li></ul><p>Read more about quality goals in <a href="./../../introduction/improving-software-quality/">our article on effective quality improvement</a>.</p></div><p>Teams use these to set explicit, clear expectations towards how they will tackle the mountain of problems identified by Teamscale continuously. They are based on a &quot;clean up where you work&quot; strategy (a.k.a. <em>the boyscout rule</em>: &quot;leave the camping site cleaner than you found it&quot;).</p><ul><li>This is <strong>cost-effective</strong> as you only clean up in code areas where you&#39;re already making modifications and already have to understand and test the code anyways.</li><li>This is <strong>low-risk</strong> as you&#39;re making changes in areas that you have already understood, modified and will test afterwards. So there&#39;s less chance of breaking something accidentally.</li></ul><p>The TQE <a href="./../../reference/ui/general-ui-features/#baselines-quality-goal-setting">continuously monitors</a> whether the team is meeting their self-imposed goal and takes action if they don&#39;t.</p><h2 id="your-pull-request-is-your-quality-gate" tabindex="-1">Your Pull Request is Your Quality Gate <a class="header-anchor" href="#your-pull-request-is-your-quality-gate" aria-label="Permalink to &quot;Your Pull Request is Your Quality Gate&quot;">​</a></h2><p>The idea of a quality gate is traditionally to &quot;break the build&quot; or &quot;halt the release&quot; if certain key performance indicators (KPIs) are not met. In our experience, this approach is rarely effective:</p><ul><li>Breaking the build as a quality gate interrupts and blocks the whole team and it&#39;s unclear who is responsible for fixing it. This is ineffective and furthermore, your team will soon learn to hate the tool that forces them to regularly fix other people&#39;s problems.</li><li>Halting the release happens too late in the development process, so there&#39;s usually too much at stake and thus these quality gates often get ignored on purpose.</li></ul><p>Thus, traditional quality gates fail to deliver on their promise of substantially helping to improve software quality. Instead, we need an approach that addresses single persons directly, does not prevent others from working and gives feedback as early as possible.</p><p>Thus, instead of one big quality gate, we recommend you use pull requests (e.g. in <a href="./../../howto/connecting-version-control-system/gitlab/">GitLab</a>, <a href="./../../howto/connecting-version-control-system/bitbucket/">Bitbucket</a>, <a href="./../../howto/connecting-version-control-system/github/">GitHub</a> or <a href="./../../howto/connecting-version-control-system/azure-devops-git/">Azure DevOps</a>) as lots of regular, small quality gates.</p><div class="tip custom-block"><p class="custom-block-title">Don&#39;t merge a pull request unless it&#39;s clean.</p><p>I.e. it introduces no new Teamscale findings. In fact, don&#39;t even send a pull request with Teamscale findings into the code peer review. Save yourself and the reviewer some time and address the problems Teamscale can find first.</p></div><p>If a pull request surfaces problems that are too big to solve between just the developer and reviewer or you are under pressure to merge, let the TQE know and discuss it in the next sprint retrospective. This hints at larger underlying issues that you need to address as a team.</p><h2 id="care-about-trends" tabindex="-1">Care about Trends <a class="header-anchor" href="#care-about-trends" aria-label="Permalink to &quot;Care about Trends&quot;">​</a></h2><p>Choose a set of KPIs and ensure they consistently improve. We suggest:</p><ul><li>Code Structure: File size, <a href="./../../glossary/#method-length">method length</a> and <a href="./../../glossary/#nesting-depth">nesting depth</a></li><li>Redundancy: <a href="./../../glossary/#clone-coverage">Clone coverage</a></li><li>Architecture: <a href="./../../reference/ui/architecture/">Architecture violations</a></li><li>Critical Problems: Number of critical findings</li><li>Tests: <a href="./../../reference/supported-technologies/test-coverage/">Test coverage</a></li></ul><div class="tip custom-block"><p class="custom-block-title">Meeting absolute KPIs is less important than continuous progress.</p><p>Especially in long-lived systems, you&#39;ll likely find yourself far from your ideal target. Spending huge effort on cleaning up old problems makes no business sense and is risky. Thus, you&#39;re unlikely to reach your idealistic KPIs any time soon. Instead, focus on small, continuous, regular improvements in these KPIs. This is achievable, rewarding, low-risk and creates lasting business value. And Teamscale makes it easy to track this both <a href="./../../reference/ui/dashboard/widgets/#metrics-table-widget">on dashboards</a> and <a href="./../../reference/ui/qualitycontrol/reports/slideoverview/#system-quality-overview-slide">with PDF reports</a>.</p></div>',27)])])}const m=t(i,[["render",r]]);export{p as __pageData,m as default};
