import{_ as t}from"./chunks/issue-details-view.DZimuOWP.js";import{_ as s,c as a,ak as i,o}from"./chunks/framework.CM689eR4.js";const r="/assets/issue-query.Sel4r0Sy.png",n="/assets/issue-trend.DV_ecwW5.png",d="/assets/issue-sidebar.B2YubkL-.png",u="/assets/issue-dashboard-widgets.2iQt3QcY.png",w=JSON.parse('{"title":"Issues View","description":"","frontmatter":{},"headers":[],"relativePath":"reference/ui/activity/issues/index.md","filePath":"reference/ui/activity/issues/index.md"}'),c={name:"reference/ui/activity/issues/index.md"};function l(h,e,p,g,m,f){return o(),a("div",null,[...e[0]||(e[0]=[i('<h1 id="issues-view" tabindex="-1">Issues View <a class="header-anchor" href="#issues-view" aria-label="Permalink to &quot;Issues View&quot;">​</a></h1><p>The main purpose of the <strong>Issue</strong> perspective is to calculate metrics over issues stored in an issue tracker. These metrics can reveal weaknesses in your development process, such as long pending critical bugs, and help you to assess any steps toward process improvement over time. To use this perspective, your project must define at least one issue tracker connector when <a href="./../../../../howto/creating-a-project/">configuring your project</a>.</p><table><tbody><tr><td><strong>Use Cases</strong></td><td>Evaluating and Managing Issue Queries</td></tr><tr><td><strong>Views</strong></td><td>Issue Query View</td></tr><tr><td><strong>Actions</strong></td><td>Query Issues, Display Issue Trend, Save Issue Queries</td></tr></tbody></table><h2 id="performing-an-issue-query" tabindex="-1">Performing an Issue Query <a class="header-anchor" href="#performing-an-issue-query" aria-label="Permalink to &quot;Performing an Issue Query&quot;">​</a></h2><p>In the Issues perspective, you can enter queries:</p><p><img src="'+r+'" alt="Issue Query" width="1172" height="510" data-zoom="true"></p><p>For example, to display all open issues, enter <code>closed = false</code> into the query box. After pressing <em>Enter</em>, the list of matching issues is displayed below the box. The input box also provides autocompletion to simplify writing queries.</p><p>Each issue in the returned list provides a link to additional details, as well as to the issue in the originating issue tracker. You should keep in mind, that the default is to query all issues, including closed one. To limit a query to open issues, add the phrase <code>closed=false</code>.</p><h3 id="issue-query-language" tabindex="-1">Issue Query Language <a class="header-anchor" href="#issue-query-language" aria-label="Permalink to &quot;Issue Query Language&quot;">​</a></h3><table><tbody><tr><td><strong>Attributes</strong></td><td>For each issue, the default attributes <code>subject</code> , <code>id</code> , <code>assignee</code> , <code>author</code> , <code>created</code> , <code>updated</code> , <code>status</code> , and <code>closed</code> are defined. Additionally, all custom fields defined in the connector configuration are made available as attributes. For connectors that support it, the `parent` field is filled with the ID of the parent issue. </td></tr><tr><td><strong>Comparison operators</strong></td><td>Attributes can be compared to values using the usual comparison operators <code>=</code>, <code>!=</code>, <code>&gt;</code>, <code>&lt;</code>, <code>&gt;=</code>, <code>&lt;=</code>. The order is always attribute, operator, value. You can not compare attributes to each other. </td></tr><tr><td><strong>Set query</strong></td><td>You can use the keyword <code>in</code> together with square brackets to create set queries. An example would be <code>priority in [high, urgent]</code>. You can use the keyword <code>like_in</code> / <code>likeIn</code> / <code>~in</code> to match an element by substring instead of equality. </td></tr><tr><td><strong>Logical operators</strong></td><td>Comparisons can be connected using the logical operators <code>&amp;&amp;</code> (and), <code>||</code> (or), and <code>!</code> (not). <br> Additionally, parentheses can be used to group subexpressions. </td></tr><tr><td><strong>Like operator</strong></td><td>The <code>like</code> operator <code>~</code> can be used to match a value against a regular expression. </td></tr><tr><td><strong>membersOf</strong></td><td>The special function <code>membersOf</code> can be used together with set queries to check for membership in a Teamscale group (that might again come from LDAP). An example would be <code>assignee in membersOf(&#39;UI Team&#39;)</code>. </td></tr><tr><td><strong>currentUser</strong></td><td>The special function <code>currentUser</code> can be used to select issues where <code>author</code> or <code>assignee</code> is current Teamscale user. An example would be <code>assignee = &#39;currentUser()&#39;</code> . </td></tr><tr><td><strong>baseline</strong></td><td>The special function <code>baseline</code> can be used to replace dates with a baseline. Note that the time of the baseline is ignored and is set to midnight i.e. just the date is used. An example would be <code>updated &gt; baseline(&#39;Release 1&#39;)</code>. </td></tr><tr><td><strong>query</strong></td><td>The built-in function <code>query</code> can be used to reference stored queries. For example <code>query(&#39;Closed Issues&#39;)</code> can be used in a query to reference a query named <code>&#39;Closed Issues&#39;</code>. </td></tr><tr><td><strong>Nested queries</strong></td><td> You can pass a query to the set query operator <code>in</code> to check if a given attribute is contained in the queries result, for example, <code>parent in query(author = currentUser())</code> would select all issues which have a parent issue that was created by the current user. Also stored queries can be referenced by specifying the name of the stored query instead of giving a query expression, for example, <code>parent in query(&#39;TicketsCreatedByMe&#39;)</code>. </td></tr><tr><td><strong>State queries</strong></td><td>The operator <code>inState</code> allows to formulate that a issue has to be in a given state for a longer time. The operator can contain any subquery and is followed by a comparison (&gt;, &lt;, &gt;=, &lt;=) with a time value. An example would be <code>inState(closed=false) &gt; 7d</code> to display all issues that are open for at least 7 days. The number can be followed by suffixes for days (d), hours (h), minutes (m) and seconds (s). The default when no suffix is given is days. Dates can also be used, for example: <code>inState(closed=false) &gt; 2018-1-12</code> returns all issues, which have been closed after 2018-1-12. This is especially useful if you want to create a static query, e.g., all closed issues in January. Additionally, the special value `@startOfMonth` can be used to get the duration of time elapsed since the start of the current month, e.g., <code>inState(closed=false) &lt; @startOfMonth</code> to display all issues closed since the start of the current month. </td></tr><tr><td><strong>Parent queries</strong></td><td>The operator <code>hasParent</code> allows to select issues based on the attributes of their parent issue. It selects issues that have a parent and whose parent matches a given sub query. An example would be <code>hasParent(closed = true)</code> to display all tickets whose parent issue has been closed. Issues that have no parent or whose parent was not imported into Teamscale are never returned by a <code>hasParent</code> query. </td></tr></tbody></table><p>An example returning all urgent issues that have not been closed within two weeks would be</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>inState(closed=false &amp;&amp; tracker=Bug &amp;&amp; priority in [urgent, blocker]) &gt; 14d</span></span></code></pre></div><p>To limit this to issues within the UI team, you can change this to</p><div class="language- vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang"></span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span>assignee in membersOf(&#39;UI team&#39;) &amp;&amp; inState(closed=false &amp;&amp; tracker=Bug &amp;&amp; priority in [urgent, blocker]) &gt; 14d</span></span></code></pre></div><p>Note that the exact attributes will depend on your issue tracker and the fields that are configured. Also note the subtle difference between including the assignee check in the <em>inState</em> part or not. If we would include the assignee check in the inState part, this would cause issues to not be shown if the assignee changed in the 2 weeks.</p><h2 id="display-issue-trend" tabindex="-1">Display Issue Trend <a class="header-anchor" href="#display-issue-trend" aria-label="Permalink to &quot;Display Issue Trend&quot;">​</a></h2><p>When an issue query has been executed, you can click on <i class="signal icon"></i><code>Show trend and treemap</code> in the <em>Issue Query View</em>, to display a trend of the number of issues matching the query over time. In addition, a treemap shows which files of your system were edited in the course of the current issues in the list:</p><p><img src="'+n+'" alt="Issue Trend" width="1286" height="579" data-zoom="true"></p><h2 id="manage-issue-queries" tabindex="-1">Manage Issue Queries <a class="header-anchor" href="#manage-issue-queries" aria-label="Permalink to &quot;Manage Issue Queries&quot;">​</a></h2><p>There are certain queries which you might want to execute continuously and see the result regularly without re-formulating the query every time. Therefore, the <strong>Issue</strong> perspective also allows you to save issue queries for later use. For saved issue queries Teamscale calculates metrics on the issues that match the query, i.e., the number of issues matching.</p><p>These stored issue queries are displayed in the sidebar:</p><p><img src="'+d+'" alt="Issue Queries in Sidebar" width="299" height="222"></p><p>To store a query, execute an issue query and click <i class="plus icon"></i><code>Save Query</code> in the <em>Issue Query View</em>. After entering a name, the metric will appear in the sidebar. The list of queries in the sidebar allows you to quickly return to the corresponding query by clicking on its name, or to delete the query by clicking <i class="close icon"></i>. Editing a query works by recreating a query with an existing name.</p><h3 id="referencing-stored-issue-queries-in-dashboards" tabindex="-1">Referencing Stored Issue Queries in Dashboards <a class="header-anchor" href="#referencing-stored-issue-queries-in-dashboards" aria-label="Permalink to &quot;Referencing Stored Issue Queries in Dashboards&quot;">​</a></h3><p>The defined issue queries are also available in the <a href="./../../dashboard/">Dashboard perspective</a> upon configuring dashboard widgets. The configuration of a widget offers you to define the scope of a widget by setting the corresponding path, which usually points to a (sub-)folder or (sub-) component of the system. To use issue queries instead, use the path <em>-issues-</em> within a project. When the query names include slashes, these are used to define directories for grouping similar issue queries. <em>Numeric Metric Value</em> and the <em>Single Metric Trend Chart</em> widget are good widgets for using the issue queries.</p><p><img src="'+u+'" alt="Issue Queries in Dashboard Widgets" width="891" height="242" data-zoom="true"></p><p>This allows you to track key indicators for your issue management process and react timely to any changes in the observed trend.</p><h2 id="view-issue-details" tabindex="-1">View Issue Details <a class="header-anchor" href="#view-issue-details" aria-label="Permalink to &quot;View Issue Details&quot;">​</a></h2><p>A click on a issue from the issue list will open the <em>Issue Details View</em>:</p><p><img src="'+t+'" alt="Image: issue-details-view" width="1146" height="1393" data-zoom="true"></p><p>The view subdivides into the following parts:</p><ul><li><p><strong>Issue meta data</strong>: This includes, among other information, the subject and the description of the issue, as well as the issue author and the current assignee.</p></li><li><p><strong>Affected files</strong>: Lists all files known to Teamscale which have been edited during the implementation of the issue. This is determined based on the <a href="./../../../connector-options/#issue-tracker-connector-options">issue IDs in the commit messages or branch names</a>.</p></li><li><p><strong>Impacted Tests</strong>: Tests that are known to run through the changed code and should be run to test it.</p></li><li><p><strong>Test Gaps</strong>: Shows the test gaps in your code base introduced with this issue (<a href="./../../../../tutorial/analyzing-issue-test-gaps/">see guide</a>).</p></li><li><p><strong>Findings</strong>: Static code analysis findings that were introduced, touched or removed during the implementation of this issue.</p></li><li><p><strong>Commits</strong> Display all commits targeting the current issue. Note that only commits which changed files known to Teamscale are considered.</p></li></ul>',32)])])}const q=s(c,[["render",l]]);export{w as __pageData,q as default};
