This check detects the usage of magic numbers in ABAP code, i.e., numeric or string values that are hardcoded without any explanation of their meaning or purpose, and is used directly in a conditional statement.

0 and 1 are not considered magic numbers.

# Why is This a Problem?
Hardcoded values make the code harder to understand and modify.
On the other hand, using named constants makes the code more readable, maintainable, and reduces the risk of errors caused by incorrect or inconsistent use of hardcoded values.

# Exceptions
In certain situations, however, using named constants can affect the readability of a program. It is better to specify a literal in these cases, as the following operands associated with literal values are ignored.
- SY-SUBRC
- SY-TABIX 
- SY-DBCNT

# How Can I Resolve This?
Replace the instances of magic numbers with named constants.

## Example (Before)

```ABAP
IF integer = 99.
    ...
ENDIF.
```

## Example (After)

```ABAP
CONSTANTS capacity TYPE i VALUE 99.
IF integer = capacity.
    ...
ENDIF.
```

# Where Can I Learn More?

## References

- [Literals - ABAP Keyword Documentation](https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abenliterals_guidl.htm)