Using `Thread.sleep` in concurrency might lead to poor performance and unpredictable behavior.
Consider alternatives for periodic tasks or properly handling the reason for the fixed time wait.

# What Does This Check Look For?

This check flags calls of `Thread.sleep`.

# Why is This a Problem?

`Thread.sleep` introduces forced wait times by a blocking call in the current thread.
Using `Thread.sleep`  _may_ be suitable in situations where data is collected for a fixed amount of time.
Often, however, the usage indicates a design problem of the system to mitigate runtime problems such as race conditions.

# How Can I Resolve This?

If calls to `Thread.sleep` are used to set the frequency of a periodic task or to add a delay, then [`ScheduledExecutorService`](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/concurrent/ScheduledExecutorService.html) offers more explicit alternatives.

# Where Can I Learn More?

- [Code Review Checklist (Java Concurrency): Item TE.8](https://github.com/code-review-checklists/java-concurrency#no-sleep-schedule)
