`SimpleDateFormat` objects should not be initialized without specifying a `Locale` object.

# Why is This a Problem?
If no `Locale` is used when initializing a `SimpleDateFormat` the default locale of the current system is used.
This can lead to different results on different machines.

# How Can I Resolve This?
Instantiate `SimpleDateFormat` objects with a `Locale`.

## Example (Before)

```java
SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
```

## Example (After)
```java
SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy", Locale.GERMANY);
```