The Java list method `addAll(Collection<? extends E> c)` should not add a list to itself.

# Why is This a Problem?

Calling the `addAll` operation on Java list objects with the list itself as parameter could lead to undefined behavior.
This is caused by the parameter, that should be appended, is the same as the list that the object will be added to,
and hence might change during the iteration.

# How Can I Resolve This?
Instead of passing the calling list as a parameter, you should pass a deep copy of the list.

## Example (Before)
``` js
someList.addAll(someList)
```
Here, `someList` changes during the iteration.
Hence, both the caller and the parameter might change, leading to undefined behavior.

## Example (After)
``` js
someList.addAll(new ArrayList<>(someList))
```
Now, first a copy of `someList` is created by creating a new list object. This way, not the same object is used,
but the same values will be added to the list.

# Where Can I Learn More?
## References
* [Oracle Java 8 ArrayList Documentation - addALL](https://docs.oracle.com/javase/8/docs/api/java/util/ArrayList.html#addAll-java.util.Collection-)