Comparing an object reference to itself using `==` or `!=`, always yields a constant result, which might not be what is intended.
Consider whether this comparison is necessary or if a different comparison is needed to achieve the intended purpose.

# What Does This Check Look For?

This check identifies instances where an object is compared to itself which will always result in a constant value (true or false).

This check applies to multiple programming languages, including Java, C, C++, C#, JavaScript, Python, TypeScript.
For all of them this check identifies instances where an object is compared to itself using `==` and `!=`. In addition, for JavaScript and TypeScript, the check identifies similar patterns using `===` or `!==` operators, while for Python, the operator `is` is also identified by this check.

# Why is This a Problem?

Comparisons of an object reference to itself are often indicative of a coding mistake or a misunderstanding. Such comparisons yield a predictable result, thus they do not contribute to logical decision-making in the code. When such a pattern is detected, it either suggests redundant code that can be removed or highlights a potential error where a comparison with a different object or property was intended.

# How Can I Resolve This?

Revisit the logic behind the comparison to ensure it aligns with the intended application behavior. If the comparison is intended to check for object existence or initialization, consider more explicit checks that reflect the intent clearly. If the comparison was meant to be with another object or value, correct the code accordingly.

# Examples

## Non-Compliant

```java
Object obj = new Object();
Object anotherObj = new Object();
if (obj == obj) {   // non-compliant: Always true; potentially a logical error
    // code
}
```

## Compliant

```java
Object obj = new Object();
Object anotherObj = new Object();
if (obj == anotherObj) {   // compliant: comparison intended between two different objects
    // code
}
```
