This check flags ROWIDs and UROWIDs that are stored in database tables.

# Why is This a Problem?
Saving ROWIDs in database tables is risky, except for some very limited scenarios of runtime duration, as any table reorganization can change these IDs, leading to data inconsistency.

# How Can I Resolve This?
Instead of using rowid for later reference to the original row one should use the primary key column(s).

# Examples
## Non-Compliant
```oraclesqlplus
begin
insert into employees_log (
employee_id
,last_name
,first_name
,rid
)
select employee_id
,last_name
,first_name
,rowid
from employees;
end;
/
```

## Compliant
```oraclesqlplus
begin
insert into employees_log (
employee_id
,last_name
,first_name
)
select employee_id
,last_name
,first_name
from employees;
end;
/
```


# Where Can I Learn More?
- [G-1060: Avoid storing ROWIDs or UROWIDs in database tables](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.2/4-language-usage/1-general/g-1060/)