Unused methods are a form of dead code, which is undesirable since it adds unnecessary complexity
and increases the difficulty of understanding and maintaining the code base.
Unused methods, like any other dead code, should be removed.

# What Does This Check Look For?

This check detects unused private methods, i.e., methods that are never referenced in the code,
and reports them as findings.

# Why is This a Problem?

The presence of such methods can increase overall code complexity, which leads to code that is harder
to understand and modify, resulting in increased maintenance costs.
Additionally, they can indicate design issues, such as overly complex class hierarchies.
Unused methods can also hint at inconsistent or incomplete code refactorings,
where code that was previously calling the method was removed, but the method itself was not.

# How Can I Resolve This?

If the methods are superfluous, they can be safely removed.
In case the functionality is still necessary but remains unused in the current implementation,
it may suggest the presence of a bug,
and, thus, the developers should consider modifying the code to incorporate the unused methods.

# Examples

## Non-Compliant

```java
public class Example {
	private void unusedMethod() {   // non-compliant: This method is declared as private but is not used anywhere in the code.
		// some implementation code
	}
	private void usedMethod() {
		// some implementation code
	}

	public void callUsedMethod() {
		usedMethod();
	}
}
```

## Compliant

```java
public class Example {
	private void usedMethod() {
		// some implementation code
	}

	public void callUsedMethod() {
		usedMethod();
	}
}

```

# Where Can I Learn More?

- [Clean Code: A Handbook of Agile Software Craftsmanship by Robert C. Martin](https://www.goodreads.com/book/show/3735293-clean-code)
- [Code Complete: A Practical Handbook of Software Construction, Second Edition by Steve McConnell](https://www.goodreads.com/book/show/4845.Code_Complete)