Assigning a variable to itself is usually unnecessary and can indicate a mistake.
Review such assignments for potential errors and remove them if they are redundant.

# Why is This a Problem?

Assignments where a variable is set to itself are often a sign of an oversight or copy-paste error, as they have no effect on the code's functionality.

# How Can I Resolve This?

Inspect the assignment to determine if it was intended or if it should be replaced by something else, such as assigning a different variable or performing a different operation.
Remove the assignment if it serves no purpose.

# Examples
## Non-Compliant

```cpp
int exampleVar = 5;
exampleVar = exampleVar;     // non-compliant: assignment of a variable to itself has no effect 
```

**Swift - ambiguity between attributes and local variables:**
This code is valid in Swift and the finding is a false positive since the attribute `content` is assigned to the local variable also called `content`.
The fix below, however, is more readable and maintainable.
```swift
class Website {
    public var content : String
    public var created : NSDate
    
    func validate() async {
        let content = content       // ambiguity between local variable & attribute
        await FormatChecker.validate(body: content)
    }
}
```

## Compliant

```cpp
int exampleVar = 5;
int anotherVar = 10;
exampleVar = anotherVar;     // compliant: assigns a different variable's value 
```

Swift:
```swift
class Website {
    public var content : String
    public var created : NSDate
    
    func validate() async {
        let content = self.content      // fix: add an explicit `self` before the attribute
        await FormatChecker.validate(body: content)
    }
}
```