Avoid expressions of the form `if (true)`.

# Why is This a Problem?
`if (true)` statements unnecessarily complicate the code as they are redundant and executed unconditionally anyway.

# How Can I Resolve This?
Simply omit the entire `if` statement.

## Example (Before)

```cpp
if (true) {
  x = y + 3;
  ...
}
```

## Example (After)

```cpp
x = y + 3;
...
```