Critical statements should be avoided since the danger to introduce security flaws is high. Usually these statements should be never used in production code. These statements might be necessary e.g., for code generators or other development related activities, but then the containing objects should be placed in packages which  will not be transported to the production system. Usages of critical statements should properly document why the statement is needed.

The statements which are regarded as critical can be specified in the analysis profile.

Statements which are considered as critical by default are:
* `EDITOR-CALL` - allows to modify ABAP programs regardless if development authorization is granted to the executing user 
* `GENERATE SUBROUTINE POOL` - generates FORM routines at runtime, security critical code could be obfuscated in this way. A severe vulnerability exists if the code is generated from an external input. 
* `INSERT REPORT` -  generates programs (REPORTS) at runtime, as with `GENERATE SUBROUTINE POOL`, security critical code could be obfuscated in this way. A severe vulnerability exists if the code is generated from external input.
* `GENERATE REPORT` - is intended for SAP-internal use only and must not be used in application programs as it can generate code similar to `GENERATE SUBROUTINE POOL`.
* `GENERATE DYNPRO` - is intended for SAP-internal use only and must not be used in application programs as it can generate code similar to `GENERATE SUBROUTINE POOL`.
* `DELETE REPORT` - is intended for SAP-internal use only and must not be used in application programs as it can delete code.
* `EXPORT NAMETAB` - results in a runtime error as the statement is not supported anymore since the internal handling of the name table that stores the runtime objects of data types in the ABAP Dictionary has changed. 
* `IMPORT NAMETAB` - similar to `EXPORT NAMETAB` but it is still supported for downward compatibility. 
* `EXPORT DYNPRO` - is intended for SAP-internal use only and must not be used in application programs as it can generate code similar to `GENERATE SUBROUTINE POOL`.
* `DELETE DYNPRO` - is intended for SAP-internal use only and must not be used in application programs as it can delete code.
* `IMPORT DYNPRO` - is intended for SAP-internal use only and must not be used in application programs as it can import security critical code.
* `INSERT TEXTPOOL` - should be used with caution as it completely overwrite existing text pool and thus might delete code.
* `DELETE TEXTPOOL` - is intended for SAP-internal use only and must not be used in application programs as it might delete code.
* `SYNTAX-CHECK FOR DYNPRO` - is intended for SAP-internal use only and must not be used in application programs
* `SYSTEM-CALL` - is intended for SAP-internal use only as calls of system functions whose names or parameters are injected into the program from outside present a serious security risk 
* `BY KERNEL MODULE` - is intended for SAP-internal use only as it might generate code
