Empty blocks may confuse the reader as it is unclear if the empty block was intended or should be filled later on.
To clarify, either remove the empty block if not needed, or add an explanatory comment to indicate its intent.

# What Does This Check Look For?

This check searches for empty blocks of code.

# Why is This a Problem?

Empty blocks can confuse readers because it is unclear if it was left blank intentionally or if it should be filled later on.
They are also easy to overlook.

# How Can I Resolve This?

Remove empty blocks if they are not needed or add an explanatory comment to clarify the intention.

**C++ destructors**: Empty and non-virtual destructors are probably not useful.
They should either be removed, marked as `=default` or made virtual (if the class is intended for subclassing).

# Examples
## Non-Compliant

```java
for (int i = 0; i < max; i++) { }   // non-compliant
```

C++ destructors:
```cpp
class MyClass {
public:
    ~MyClass() {}   // non-compliant
}
```

## Compliant

```java
for (int i = 0; i < max; i++) {
    // intentional no op
}
```

C++ destructors:
```cpp
class MyClass {
public:
    virtual ~MyClass() {}   // compliant: marked as virtual
}
```

# Where Can I Learn More?

 [Guideline: C++ Core Guidelines: ES.85 - Make empty statements visible](https://isocpp.github.io/CppCoreGuidelines/CppCoreGuidelines#Res-empty)