Docstrings that are not enclosed in triple quotes can affect the accuracy and clarity of code documentation. 
Therefore, triple quotes should be used for docstrings to ensure consistent and correct display in documentation tools or IDEs.

# What Does This Check Look For?

This check identifies documentation strings (also known as docstrings) that are not enclosed in triple quotes.
A docstring is a string literal occuring as first statement in a method or type definition (see [PEP 257 - Docstring Conventions: What is a Docstring?](https://peps.python.org/pep-0257/#what-is-a-docstring)).


# Why is This a Problem?

Docstrings provide valuable information for developers and users of your code.
By not enclosing doc-strings in triple quotes, it becomes difficult to write multi-line descriptions or include proper formatting.
This can lead to unclear or incomplete documentation, making it harder for others to understand and use your code effectively.

In addition, missing triple quotes may cause incorrect interpretation of the documentation by tools cause compilation errors.

# How Can I Resolve This?

To resolve this issue, make sure that all docstrings are enclosed in triple quotes (`"""..."""` or `'''...'''`).
This allows you to write multi-line descriptions, include proper formatting, and provide comprehensive documentation for your code.

# Examples

## Non-Compliant

```python
def someFunction():
    'This is a not a non-compliant docstring'  
    
    # code here
```

## Compliant

```python
def someFunction():
    """ This is compliant a docstring that provides information about the purpose and usage of the function."""
    
    # code here
    
```

# Where Can I Learn More?
- [Python Docs: Documentation Strings](https://docs.python.org/3/tutorial/controlflow.html#documentation-strings)
- [Guideline: PEP 257 - Docstring Conventions](https://www.python.org/dev/peps/pep-0257)
