This check detects include statements that are preceded by source code (i.e., anything that is not a preprocessor directive or a comment).

An exception is made for any header file that contains template specifications, to allow for a coding style where template declaration and implementation are kept in separate files.

# Why is This a Problem?

Grouping includes together at the top of the file is a widely followed best practice. 
It establishes clarity about what is being included from the very beginning of the file, thus resulting in better readability.

# How Can I Resolve This?

Most of the time, it is possible to reorder the file such that all include the directives appear at the top before any other code.

In some cases, it might be necessary to add additional preprocessor statements to permit this.
See the example below for such a case and how to resolve it.

## Example (Before)

```C
#include <stdio.h>
#include <stdint.h>

size_t counter = 0;

#include <stddef.h>   // non compliant 
```

```C
#if defined(FEATURE_FLAG)
#include "feature_header.h"
// ... (all other includes for FEATURE_FLAG)

some_feature_function(void);
// ... (all other definitions or declarations for FEATURE_FLAG)
#else
#include "not_feature_header.h"   // non compliant
// ... (all other includes for not FEATURE_FLAG)

some_not_feature_function(void);
// ... (all other definitions or declarations for not FEATURE_FLAG)
#endif 
```

## Example (After)

```C
#include <stdio.h>
#include <stdint.h>
#include <stddef.h>

size_t counter = 0;
```

```C
#if defined(FEATURE_FLAG)
#include "feature_header.h"
// ... (all other includes for FEATURE_FLAG)
#else
#include "not_feature_header.h"
// ... (all other includes for not FEATURE_FLAG)
#endif 

#if defined(FEATURE_FLAG)
some_feature_function(void);
// ... (all other definitions or declarations for FEATURE_FLAG)
#else
some_not_feature_function(void);
// ... (all other definitions or declarations for not FEATURE_FLAG)
#endif 
```
