Short integers are gone in Python 3 and ``long`` has become ``int`` (without the trailing ``L`` in the ``repr``).
``` python
# Python 2 only
k = 9223372036854775808L

# Python 2 and 3:
k = 9223372036854775808
```
  
``` python
# Python 2 only
bigint = 1L

# Python 2 and 3
from builtins import int
bigint = int(1)
```
  
To test whether a value is an integer (of any kind):
``` python
# Python 2 only:
if isinstance(x, (int, long)):
    ...

# Python 3 only:
if isinstance(x, int):
    ...

# Python 2 and 3: option 1
from builtins import int    # subclass of long on Py2

if isinstance(x, int):             # matches both int and long on Py2
    ...

# Python 2 and 3: option 2
from past.builtins import long

if isinstance(x, (int, long)):
    ...
```
  

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)