This check detects functions with multiple `RETURN` statements.

# Why is This a Problem?
Functions containing multiple `RETURN` statements are more complex and harder to maintain.


# How Can I Resolve This?
A `FUNCTION` should only include one `RETURN` statement.
The returned value should then be set within the function.

## Example (Before)

```oraclesqlplus
    FUNCTION nonCompliant() RETURN BOOLEAN IS
    BEGIN
        IF foo THEN
            RETURN TRUE;
        ELSE
            RETURN FALSE;
        END IF;
    END nonCompliant;
```

## Example (After)

```oraclesqlplus
    FUNCTION compliant() RETURN BOOLEAN IS
        returnValue BOOLEAN;
    BEGIN
        IF foo THEN
            returnValue := TRUE;
        ELSE
            returnValue := FALSE;
        END IF;
        RETURN returnValue;
    END compliant;
```

# Where Can I Learn More?

## Guidelines

- [PL/SQL & SQL Coding Guidelines Version 4.0: G-7430: Try to use no more than one RETURN statement within a function.](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.0/4-language-usage/7-stored-objects/4-functions/g-7430/)