Avoid the usage of public variables.
Instead, change public variables to properties, in order to provide an interface to other code that is separated from the implementation.

# Why is This a Problem?

Exposing public variables means that the internal implementation (e.g. type of variable) can not be changed without breaking the public interface.

# How Can I Resolve This?

Use properties instead of public variables so the interface is separated from the implementation.

# Examples

## Non-Compliant

``` java 
class Test {
	public var FirstName : String
...
``` 

## Compliant

``` java 
class Test {
	public var _firstName : String as FirstName
...
``` 
