Field symbols in ABAP are similar to pointers in other programming languages. 
Statements like `READ TABLE` have special syntax for assigning field symbols.
This check tries to prevent undesired changes to the content referenced by a field symbol.

# What Does This Check Look For?

This check searches for `READ TABLE` statements using an `INTO` clause with a 
field symbol as their target.

# Why is This a Problem?

Using `INTO` with a field symbol overwrites the referenced content when the
programmer probably intended to assign (or re-assign) the field symbol instead.

# How Can I Resolve This?

Use the `ASSIGNING` syntax in combination with field symbols.

# Examples
## Non-Compliant

```ABAP
READ TABLE itab INTO <fs> WITH KEY key = '1'.
```

## Compliant

```ABAP
" with inline declaration
READ TABLE itab ASSIGNING FIELD-SYMBOL(<fs>) WITH KEY key = '1'.

" with a field-symbol declared up-front
READ TABLE itab ASSIGNING <fs> WITH KEY key = '1'. 
```

# Where Can I Learn More?

- [code pal for ABAP: READ TABLE with Subsequent Memory Assignment](https://github.com/SAP/code-pal-for-abap/blob/master/docs/checks/sub-assign-read-table.md)

