If you are upgrading an existing Python 2 codebase, it may be preferable to mark up all string literals as unicode explicitly with ``u`` prefixes:
``` python
# Python 2 only
s1 = 'The Zen of Python'
s2 = u'きたないのよりきれいな方がいい\n'

# Python 2 and 3
s1 = u'The Zen of Python'
s2 = u'きたないのよりきれいな方がいい\n'
```
  
The ``futurize`` and ``python-modernize`` tools do not currently offer an option to do this automatically.
If you are writing code for a new project or new codebase, you can use this idiom to make all string literals in a module unicode strings:
``` python
# Python 2 and 3
from __future__ import unicode_literals    # at top of module

s1 = 'The Zen of Python'
s2 = 'きたないのよりきれいな方がいい\n'
```
  
See http://python-future.org/unicode_literals.html for more discussion on which style to use.

See also [Cheat Sheet: Writing Python 2-3 compatible code](http://python-future.org/compatible_idioms.html)

[Copyright (c) 2013-2016 Python Charmers Pty Ltd, Australia](https://github.com/PythonCharmers/python-future/blob/master/LICENSE.txt)