Methods named similarly to those in `Object` might lead to confusion or indicate a typing error.
Consider renaming these methods to avoid ambiguity.

# What Does This Check Look For?

This check flags methods whose names are similar to `Object` class methods.

# Why is This a Problem?

Method names closely resembling those of the `Object` class can lead to misunderstandings or could be a result of a typing mistake. Such instances may cause bugs that are hard to detect or lead to unexpected behavior, especially if overriding was the intended action but is not effectively achieved due to a typo.

# How Can I Resolve This?

Review the method names that resemble those of the `Object` class. If the similarity was unintended, rename the methods to clearly convey their purpose, avoiding conflicts or confusion with `Object` class methods. If overriding an `Object` class method was intended, double-check the method signature to ensure it matches exactly. Also consider adding an `@Override` annotation to clearly mark the intention.

# Examples

## Non-Compliant

```java
class MyClass {
    public boolean equal(Object obj) {    // non-compliant: typo likely meant to override equals from Object class
        // implementation
    }
}
```

## Compliant

```java
class MyClass {
    @Override
    public boolean equals(Object obj) {    // compliant: correctly overrides Object.equals
        // implementation
    }
}
```
