Test classes should be easily identifiable by their naming convention. Ensure test class names match the configured naming pattern.

# What Does This Check Look For?

This check reports a finding when the name of a test class does not follow the predefined naming convention.

# Why is This a Problem?

Test classes that do not follow a consistent naming convention can be harder to locate and might be mistakenly used as regular classes. This can lead to confusion and reduce the overall test maintainability and readability. Consistency in test class naming helps distinguish them from production code and other types of classes, facilitating better organization and understanding of the test suite.

# How Can I Resolve This?

Ensure that test classes follow the naming convention specified in your project's configuration. Typically, test classes are named by appending 'Test' to the name of the class they are testing (e.g., `UserServiceTest` for a class named `UserService`). Adjusting test class names to follow this or a similar pattern consistent with your project's guidelines will resolve this issue.

# Examples

## Non-Compliant

```java
import org.junit.jupiter.api.Test

public class ServiceCheck {
	@Test
	public void foo() {
		// ...
	}
}

```

## Compliant

```java
import org.junit.jupiter.api.Test

public class ServiceCheckTest {
	@Test
	public void foo() {
		// ...
	}
}

```
