Superfluous `toString()`/`ToString()` calls on string objects are redundant and can reduce code readability.
Consider removing unnecessary `toString()`/`ToString()` calls to enhance clarity and maintainability.

# What Does This Check Look For?

This check identifies instances where the `toString()` (for Java) / `ToString()` (for C#) method is called on objects that are already of type String.

# Why is This a Problem?

Using `toString()`/`ToString()` on objects that are already strings does not change the object or provide any additional benefit. Instead, it adds unnecessary complexity to the code, making it harder to read and maintain. It can also mislead developers into thinking that a conversion or some form of processing is taking place when it is not. Additionally, although the performance impact might be minimal in most cases, calling unnecessary methods does add overhead.

# How Can I Resolve This?

Review the identified instances and remove the `toString()`/`ToString()` calls from objects that are confirmed to be strings. This simplification will make your code more straightforward and more readable.

# Examples

## Non-Compliant

```java
String myString = "Hello, World!";
System.out.println(myString.toString());
```

## Compliant

```java
String myString = "Hello, World!";
System.out.println(myString);
```
