Using a `CASE` expression instead of an `IF` statement with multiple `ELSIF` paths can improve the readability and maintainability of your code.

# What Does This Check Look For?
This check detects `IF` statements having at least one `ELSE` and one `ELSIF`, or if no `ELSE` is present then having several `ELSIF`s.

# Why is This a Problem?
`IF` statements with multiple `ELSIF` paths can become complex and hard to understand when the number of conditions increases. 
It could lead to difficulties in code maintenance and potential errors creeping in due to misinterpretation of the complex conditions.

# How Can I Resolve This?
Refactor such `IF` statements with multiple `ELSIF` paths into `CASE` statements. 
`CASE` statements represent the multiple branching structure more clearly and succinctly, thus improving code readability and maintainability.

## Non-Compliant

```oraclesqlplus
IF condition1 THEN
    -- some code
ELSIF condition2 THEN
    -- some code
ELSIF condition3 THEN 
    -- some code
END IF;
```

## Compliant

```oraclesqlplus
CASE
    WHEN condition1 THEN
        -- some code
    WHEN condition2 THEN
        -- some code
    WHEN condition3 THEN
        -- some code
END CASE;
```

# Where Can I Learn More?

- [G-4210: Try to use CASE rather than an IF statement with multiple ELSIF paths](https://trivadis.github.io/plsql-and-sql-coding-guidelines/v4.2/4-language-usage/4-control-structures/2-case-if-decode-nvl-nvl2-coalesce/g-4210/)