The description field should not contain ambiguous logical statements or combinators as they can lead to misunderstanding or misinterpretation. Use explicit, unambiguous language instead.

# What Does This Check Look For?

This check inspects the specified field for ambiguous logical statements such as 'or', 'and', 'then' and further terms that are ambiguous. It also flags combinators that join clauses, these might include "and", "or", "then", "unless", "but", "as well as", "but also", "however", "whether", "meanwhile", "whereas", "on the other hand", or "otherwise".

# Why is This a Problem?

Ambiguity in a requirement's description can lead to implementation divergence, causing inconsistencies in the understanding of the requirement between different stakeholders. This can ultimately lead to software bugs, incorrect implementations, or incomplete fulfillment of the requirement.

# How Can I Resolve This?

In places with ambiguous statements, change the language to be explicit about what is meant. If a single requirement contains multiple logical instructions, it may be better to split these into multiple individual requirements, each of which is clearly and unambiguously expressed.

# Examples

### Non-Compliant
```markdown
# Social Media Sign-in Feature
Requirement Description:
Develop a feature to facilitate the sign-in for users via their social media accounts. 
The feature should incorporate a sign-in button on the login page of our website. 
Once the user clicks on the button, they are redirected to the specific social media page for authentication and thereafter redirected back to the home page once successful sign-in is achieved. 
The feature is also expected to handle errors such as incorrect password entry by informing the user about the error and encouraging them to try again. 
0All these while ensuring data privacy and security for the users.

// non-compliant: Numerous instances of combining clauses with 'and', 'once', and 'while'.
```

### Compliant
```markdown
# Social Media Sign-in Feature
Requirement Description:
Implement a Social Media sign-in feature. 
Ensure redirection for user authentication, handle invalid password entries, maintain user data privacy, and provide security.

// compliant: Precise language without combining clauses.
```
## Where Can I Learn More?

- Guideline: ISO/IEC/IEEE 29148: Ambiguous logical statements (e.g., ‘or’, ‘and/or’)— consider multiple requirements in this case.
- Guideline: INCOSE R19: Avoid combinators that join clauses, such as “and”, “or”, ”then”, ”unless”, ”but”, ”as well as”, ”but also”, ”however”, ”whether”, ”meanwhile”, ”whereas”, ”on the other hand”, or ”otherwise.”