<p>This rule reports syntax errors in Spring Expression Language (SpEL) expressions.</p>
<h2>Why is this an issue?</h2>
<p>SpEL is used in Spring annotations and is parsed by the Spring framework, not by the Java compiler. This means that invalid SpEL expressions are
not detected during Java compile time. They will cause exceptions during runtime instead, or even fail silently with the expression string interpreted
as a simple string literal by Spring.</p>
<h3>Exceptions</h3>
<p>This rule does report syntactical errors in SpEL expressions but does not consider semantic errors, such as unknown identifiers or incompatible
operand data types.</p>
<h2>How to fix it</h2>
<p>Correct the syntax error in the SpEL expression.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
@Value("#{systemProperties['user.region'}") // Noncompliant, unclosed "["
private String region;
```

```java
@Value("#{'${listOfValues}' split(',')}") // Noncompliant, missing operator
private List<String> valuesList;
```

```java
@Value("#{T(java.lang.Math).random() * 64h}") // Noncompliant, invalid number
private Double randPercent;
```

```java
@Query("SELECT u FROM User u WHERE u.status = :#{#status+}") // Noncompliant, missing operand for "+"
List<User> findUsersByStatus(@Param("status") String status);
```
<h4>Compliant solution</h4>

```java
@Value("#{systemProperties['user.region']}") // Compliant
private String region;
```

```java
@Value("#{'${listOfValues}'.split(',')}") // Compliant
private List<String> valuesList;
```

```java
@Value("#{T(java.lang.Math).random() * 100.0}") // Compliant
private Double randPercent;
```

```java
@Query("SELECT u FROM User u WHERE u.status = :#{#status+42}") // Compliant
List<User> findUsersByStatus(@Param("status") String status);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.spring.io/spring-framework/reference/core/expressions.html">Spring Framework - Spring Expression Language (SpEL)</a>
  </li>
</ul>