Guideline for updating the Cppcheck version
======================================================
## Update version number
If you want to update to a newer version, search for/update the version number (e.g., "2.17.1" and "cppcheck-2.17.1") in
 1. the docs/ folder
 2. test data. For example, server/com.teamscale.service/src/test/resources/com/teamscale/service/findings/cppcheck/expectedServiceResponse.txt

## Integrate new rules / remove outdated rules
You need to update the check-mappings.tsv file such that it matches to the rules that can be checked with the new Cppcheck version.
If there are rules that can't be checked anymore or rules that have renamed ids, you need to remove/rename them from the check-mappings.tsv file and write an analysis-profile migration.

To determine ids of "normal" rules run `bin/cppcheck --errorlist > errorlist.xml` with the previous and the new version of Cppcheck.
Compare the documents to determine which rules changed.
The error list also contains readable names for the rules.

To determine rules in the "misra" addon of Cppcheck, run `bin/cppcheck --addon=misra --enable=warning,style,performance,portability,information,missingInclude --checkers-report=report test.cpp` with the previous and the new version of Cppcheck.
The `test.cpp` file must exist but can be empty.
The report contains the misra rules, but you have to manually derive the ids from the report format.
Readable names for the rules are not available from Cppcheck.
You have to get them from the MISRA PDFs.