# Description
Detects lines exceeding the provided maximum length.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#stick-to-a-reasonable-line-length
https://docs.abapopenchecks.org/checks/04/

# Clean ABAP Code Style Guide
Adhere to a maximum line length of 120 characters.

The human eye reads text more comfortably if the lines are not too wide -
ask a UI designer or eye movement researcher of your choice.
You will also appreciate the narrower code when debugging or comparing two sources next to each other.

The 80 or even 72 characters limit originating in the old terminal devices is a little too restrictive.
While 100 characters are often recommended and a viable choice, 120 characters seem to work a little better for ABAP,
maybe because of the general verbosity of the language.

> As a reminder you can configure in ADT the print margin to 120 characters,
> which then is visualized in the code view as a vertical line.
> Configure it under _Menu_ > _Window_ > _Preferences_ > _General_ > _Editors_ > _Text Editors_.

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/line_length) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
