# Description
Finds chained assignments and reports issues.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#dont-chain-assignments

# Examples
**Bad example**
```abap
var1 = var2 = var3.
```

**Good example**
```abap
var2 = var3.
var1 = var2.
```

# Clean ABAP Code Style Guide
```abap
" anti-pattern
var1 = var2 = var3.
```

Chained assignments usually confuse the reader. Besides, the inline declaration doesn't work in any position of a multiple assignment.

```abap
var2 = var3.
var1 = var3.
```

Furthermore, the anti-pattern looks ambiguous because `=` is used for comparisons and assignments in ABAP. It looks similar to how other programming languages implement comparisons, for example `a = ( b == c )` in JavaScript. [Use `xsdbool` for comparisons.](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#use-xsdbool-to-set-boolean-variables)

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/no_chained_assignment) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
