# Description
Checks for usages of certain obsolete statements

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-functional-to-procedural-language-constructs

https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#avoid-obsolete-language-elements

SET EXTENDED CHECK: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abapset_extended_check.htm

IS REQUESTED: https://help.sap.com/doc/abapdocu_750_index_htm/7.50/en-US/abenlogexp_requested.htm

WITH HEADER LINE: https://help.sap.com/doc/abapdocu_750_index_htm/7.50/en-US/abapdata_header_line.htm

FIELD-SYMBOLS STRUCTURE: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abapfield-symbols_obsolete_typing.htm

TYPE-POOLS: from 702, https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abennews-71-program_load.htm

`LOAD` addition: from 702, https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abennews-71-program_load.htm

`COMMUNICATION`: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abapcommunication.htm

`OCCURS`: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abapdata_occurs.htm

`PARAMETER`: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-US/abapparameter.htm

`RANGES`: https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abapranges.htm

`PACK`: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abappack.htm

`MOVE`: https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-us/abapmove_obs.htm

`SELECT without INTO`: https://help.sap.com/doc/abapdocu_731_index_htm/7.31/en-US/abapselect_obsolete.htm
`SELECT COUNT(*)` is considered okay

`FREE MEMORY`: https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-us/abapfree_mem_id_obsolete.htm

`SORT BY FS`: https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abapsort_itab_obsolete.htm

`CALL TRANSFORMATION OBJECTS`: https://help.sap.com/doc/abapdocu_752_index_htm/7.52/en-US/abapcall_transformation_objects.htm

`POSIX REGEX`: https://help.sap.com/doc/abapdocu_755_index_htm/7.55/en-US/index.htm

`OCCURENCES`: check for `OCCURENCES` vs `OCCURRENCES`

`CLIENT SPECIFIED`, from 754: https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/index.htm?file=abapselect_client_obsolete.htm

# Examples
**Bad example**
```abap
REFRESH itab.

COMPUTE foo = 2 + 2.

MULTIPLY lv_foo BY 2.

INTERFACE intf LOAD.

IF foo IS SUPPLIED.
ENDIF.
```


# Clean ABAP Code Style Guide
They are usually shorter and come more natural to modern programmers.

```ABAP
DATA(variable) = 'A'.
" MOVE 'A' TO variable.

DATA(uppercase) = to_upper( lowercase ).
" TRANSLATE lowercase TO UPPER CASE.

index += 1.         " >= NW 7.54
index = index + 1.  " < NW 7.54
" ADD 1 TO index.

DATA(object) = NEW /clean/my_class( ).
" CREATE OBJECT object TYPE /dirty/my_class.

result = VALUE #( FOR row IN input ( row-text ) ).
" LOOP AT input INTO DATA(row).
"  INSERT row-text INTO TABLE result.
" ENDLOOP.

DATA(line) = value_pairs[ name = 'A' ]. " entry must exist
DATA(line) = VALUE #( value_pairs[ name = 'A' ] OPTIONAL ). " entry can be missing
" READ TABLE value_pairs INTO DATA(line) WITH KEY name = 'A'.

DATA(exists) = xsdbool( line_exists( value_pairs[ name = 'A' ] ) ).
IF line_exists( value_pairs[ name = 'A' ] ).
" READ TABLE value_pairs TRANSPORTING NO FIELDS WITH KEY name = 'A'.
" DATA(exists) = xsdbool( sy-subrc = 0 ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/obsolete_statement) <br>
The contents within section `Clean ABAP Code Style Guide` were copied (except for text that cross-references other rules) from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
