# Description
Omit `RECEIVING`.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#omit-receiving

# Examples
**Bad example**
```abap
upload_pack(
        EXPORTING
          io_client       = lo_client
          iv_url          = iv_url
          iv_deepen_level = iv_deepen_level
          it_hashes       = lt_hashes
        RECEIVING
          rt_objects      = et_objects ).
```

**Good example**
```abap
et_objects = upload_pack(
        io_client       = lo_client
        iv_url          = iv_url
        iv_deepen_level = iv_deepen_level
        it_hashes       = lt_hashes ).
```

# Clean ABAP Code Style Guide
```ABAP
DATA(sum) = aggregate_values( values ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
aggregate_values(
  EXPORTING
    values = values
  RECEIVING
    result = DATA(sum) ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/omit_receiving) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
