# Description
Prefer `corresponding( )` to `MOVE-CORRESPONDING`, from v740sp05 and up

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-functional-to-procedural-language-constructs

# Examples
**Bad example**
```abap
MOVE-CORRESPONDING foo TO bar.
```

**Good example**
```abap
bar = CORRESPONDING #( foo ).
```

# Clean ABAP Code Style Guide
They are usually shorter and come more natural to modern programmers.

```ABAP
DATA(variable) = 'A'.
" MOVE 'A' TO variable.

DATA(uppercase) = to_upper( lowercase ).
" TRANSLATE lowercase TO UPPER CASE.

index += 1.         " >= NW 7.54
index = index + 1.  " < NW 7.54
" ADD 1 TO index.

DATA(object) = NEW /clean/my_class( ).
" CREATE OBJECT object TYPE /dirty/my_class.

result = VALUE #( FOR row IN input ( row-text ) ).
" LOOP AT input INTO DATA(row).
"  INSERT row-text INTO TABLE result.
" ENDLOOP.

DATA(line) = value_pairs[ name = 'A' ]. " entry must exist
DATA(line) = VALUE #( value_pairs[ name = 'A' ] OPTIONAL ). " entry can be missing
" READ TABLE value_pairs INTO DATA(line) WITH KEY name = 'A'.

DATA(exists) = xsdbool( line_exists( value_pairs[ name = 'A' ] ) ).
IF line_exists( value_pairs[ name = 'A' ] ).
" READ TABLE value_pairs TRANSPORTING NO FIELDS WITH KEY name = 'A'.
" DATA(exists) = xsdbool( sy-subrc = 0 ).
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/prefer_corresponding) <br>
The contents within section `Clean ABAP Code Style Guide` were copied (except for text that cross-references other rules) from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
