# Description
Prefer inline to up-front declarations.

# Extended Information
**EXPERIMENTAL**

Activates if language version is v740sp02 or above.

Variables must be local(`METHOD` or `FORM`).

No generic or void typed variables. No syntax errors.

First position used must be a full/pure write.

Move statement is not a cast(`?=`)

https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-inline-to-up-front-declarations

# Examples
**Bad example**
```abap
DATA foo TYPE i.
foo = 2.
DATA percentage TYPE decfloat34.
percentage = ( comment_number / abs_statement_number ) * 100.
```

**Good example**
```abap
DATA(foo) = 2.
DATA(percentage) = CONV decfloat34( comment_number / abs_statement_number ) * 100.
```

# Clean ABAP Code Style Guide
If you follow these guidelines, your methods will become so short (3-5 statements)
that declaring variables inline at first occurrence will look more natural

```ABAP
METHOD do_something.
  DATA(name) = 'something'.
  DATA(reader) = /clean/reader=>get_instance_for( name ).
  result = reader->read_it( ).
ENDMETHOD.
```

than declaring variables with a separate `DATA` section at the beginning of the method

```ABAP
" anti-pattern
METHOD do_something.
  DATA:
    name   TYPE seoclsname,
    reader TYPE REF TO /dirty/reader.
  name = 'something'.
  reader = /dirty/reader=>get_instance_for( name ).
  result = reader->read_it( ).
ENDMETHOD.
```

> Read more in _Chapter 5: Formatting: Vertical Distance: Variable Declarations_ of [Robert C. Martin's _Clean Code_].

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/prefer_inline) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
