# Description
Prefer `RETURNING` to `EXPORTING`. Generic types cannot be `RETURNING`.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-returning-to-exporting
https://docs.abapopenchecks.org/checks/44/

# Clean ABAP Code Style Guide
```ABAP
METHODS square
  IMPORTING
    number        TYPE i
  RETURNING
    VALUE(result) TYPE i.

DATA(result) = square( 42 ).
```

Instead of the needlessly longer

```ABAP
" anti-pattern
METHODS square
  IMPORTING
    number TYPE i
  EXPORTING
    result TYPE i.

square(
  EXPORTING
    number = 42
  IMPORTING
    result = DATA(result) ).
```

`RETURNING` not only makes the call shorter,
it also allows method chaining and prevents [same-input-and-output errors](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#take-care-if-input-and-output-could-be-the-same).

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/prefer_returning_to_exporting) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
