# Rule 20.8 The controlling expression of a `#if` or `#elif` preprocessing directive shall evaluate to 0 or 1

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
This rule does not apply to controlling expressions in preprocessing directives which are not evaluated.
Controlling expressions are not evaluated if they are within code that is being excluded and cannot
have an effect on whether code is excluded or not.

## Rationale
Strong typing requires the controlling expression of conditional inclusion preprocessing directives to
have a Boolean value.

## Example
```c
#define FALSE 0
#define TRUE 1
#if FALSE /* Compliant */
#endif
#if 10 /* Non-compliant */
#endif
#if ! defined ( X ) /* Compliant */
#endif
#if A > B /* Compliant assuming A and B are numeric */
#endif
```

## See also
Rule 14.4

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
