# Rule 5.3 An identifier declared in an inner scope shall not hide an identifier declared in an outer scope

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
An identifier declared in an inner scope shall be distinct from any identifier declared in an outer scope.

The definition of distinct depends on the implementation and the version of the C language that is being used:
* In C90 the **minimum** requirement is that the first 31 characters are significant;
* In C99 the **minimum** requirement is that the first 63 characters are significant, with each universal character or extended source character counting as a single character.

## Rationale
If an identifier is declared in an inner scope but is not distinct from an identifier that already exists in an outer scope, then the inner-most declaration will “hide” the outer one. This may lead to developer confusion.

Note: An identifier declared in one name space does not hide an identifier declared in a different name space.

The terms outer and inner scope are defined as follows:
* Identifiers that have file scope can be considered as having the outermost scope;
* Identifiers that have block scope have a more inner scope;
* Successive, nested blocks, introduce more inner scopes.

## Example
```c
void fn1 ( void )
{
  int16_t i; /* Declare an object "i" */

  {
    int16_t i; /* Non-compliant - hides previous "i" */

    i = 3;     /* Could be confusing as to which "i" this refers */
  }
}

struct astruct
{
  int16_t m;
};

extern void g ( struct astruct *p );

int16_t xyz = 0; /* Declare an object "xyz" */

void fn2 ( struct astruct xyz ) /* Non-compliant - outer "xyz" is
                                 * now hidden by parameter name */
{
  g ( &xyz );
}

uint16_t speed;

void fn3 ( void )
{
  typedef float32_t speed; /* Non-compliant - type hides object */
}
```

## See also
Rule 5.2, Rule 5.8

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
