# Rule 10.5 The value of an expression should not be cast to an inappropriate essential type
## Category
Advisory
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
The casts which should be avoided are shown in the following table, where values are cast (explicitly converted) to the *essential type category* of the first column.

| | from | | | | | | |
|---|---|---|---|---|---|---|---|
| to | Boolean | character | enum | signed | unsigned | real floating | complex floating |
| Boolean | - | Avoid | Avoid | Avoid | Avoid | Avoid | Avoid |
| character | Avoid | - | Avoid | Avoid | | Avoid | Avoid |
| enum | Avoid | Avoid | Avoid* | Avoid | Avoid | Avoid | Avoid |
| signed | Avoid | | | - | | | |
| unsigned | Avoid | | | | - | | |
| real floating | Avoid | Avoid | | | | - | |
| complex floating | Avoid | Avoid | | | | | - |

Note: an enumerated type may be cast to an enumerated type provided that the cast is to the same *essential enumerated* type. Such casts are redundant.
Casting from *void* to any other type is not permitted as it results in undefined behaviour. This is covered by Rule 1.3.
## Rationale
An explicit cast may be introduced for legitimate functional reasons, for example:
- To change the type in which a subsequent arithmetic operation is performed;
- To truncate a value deliberately;
- To make a type conversion explicit in the interests of clarity.
However, some explicit casts are considered inappropriate:
- In C99 and later, the result of a cast or assignment to `_Bool` is always 0 or 1. This is not necessarily the case when casting to another type which is defined as *essentially Boolean*;
- A cast to an *essentially enum type* may result in a value that does not lie within the set of enumeration constants for that type;
- A cast from *essentially Boolean* to any other type is unlikely to be meaningful;
- Converting between floating and character types is not meaningful as there is no precise mapping between the two representations.
## Exception
An *integer constant expression* with the value 0 or 1 and either *essentially signed* or *essentially unsigned type* may be cast to a type which is defined as *essentially Boolean*. This allows the implementation of Boolean models in C90.
## Example
```c
( bool_t ) false /* Compliant - 'false' from stdbool.h is essentially Boolean */
( int32_t ) 3U /* Compliant */
( bool_t ) 0 /* Compliant - by exception */
( bool_t ) 3U /* Non-compliant */
( int32_t ) ena /* Compliant */
( enum enuma ) 3 /* Non-compliant */
( char ) enc /* Compliant */
```
## See also
Rule 10.3, Rule 10.8

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
