# Rule 16.2 A switch label shall only be used when the most closely-enclosing compound statement is the body of a switch statement
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Rationale
The C Standard permits a *switch label*, i.e. a *case* label or *default* label, to be placed before any statement contained in the body of a *switch* statement, potentially leading to unstructured code. In order to prevent this, a *switch label* shall only appear at the outermost level of the compound statement forming the body of a *switch* statement.
## Example
```c
switch ( x )
{
 case 1: /* Compliant */
 if ( flag )
 {
 case 2: /* Non-compliant */
 x = 1;
 }
 break;
 default:
 break;
}
```
## See also
Rule 16.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
