# Rule 17.9 A function declared with a _Noreturn function specifier shall not return to its caller
## Category
Mandatory
## Analysis
Undecidable, System
## Applies to
C11
## Rationale
By definition, use of the *_Noreturn* function specifier indicates unambiguously that a function is not expected to return to its caller, by any path.
Returning from such a function is indicative of an error in the program's control flow, resulting in undefined behaviour.
## Example
```c
_Noreturn void a ( void )
{
 return; /* Non-compliant - breaks _Noreturn contract */
}

_Noreturn void b ( void )
{
 while ( true ) /* Permitted by Rule 14.3 Exception 1 */
 {
 ...
 }
 /* Compliant - function can never return */
}

_Noreturn void c ( void )
{
 abort(); /* Compliant - no return from abort() */
}

_Noreturn void d ( int32_t i )
{
 if ( i > 0 )
 {
 abort();
 }
 
 /* Non-compliant - returns if i <= 0 */
}
```
## See also
Rule 17.11

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
